<?php

add_action('init', 'SLIDE_SWP_create_events_post', 11);
function SLIDE_SWP_create_events_post() 
{
	$slug = SLIDE_SWP_JPT_get_plugin_option("event");
	if ("" == $slug) {
		$slug = "js_events";
	}
	
	register_post_type('js_events',
		array(
			'labels' => array(
				'name' =>  esc_html__('Events', 'slide-music-core') ,
				'singular_name' =>  esc_html__('Events', 'slide-music-core') ,
				'add_new' => esc_html__('Add New Event', 'slide-music-core'),
				'add_new_item' => esc_html__('Add New Event', 'slide-music-core'),
				'edit' => esc_html__('Edit', 'slide-music-core'),
				'edit_item' => esc_html__('Edit Event', 'slide-music-core'),
				'new_item' => esc_html__('New Event', 'slide-music-core'),
				'view' => esc_html__('View', 'slide-music-core'),
				'view_item' => esc_html__('View Event', 'slide-music-core'),
				'search_items' => esc_html__('Search Events', 'slide-music-core'),
				'not_found' => esc_html__('No Event Found','slide-music-core'),
				'not_found_in_trash' => esc_html__('No Event Found in Trash','slide-music-core'),
				'parent' => esc_html__('Parent Event','slide-music-core')
			),
		'public' => true,
		'rewrite' => array(
			'slug' => $slug,
			'with_front' => false
			),		
		'supports' => array('title', 'editor', 'comments', 'thumbnail'),
		'menu_icon' => 'dashicons-calendar',
		)
	); 
}

/*
	Add metabox
*/

add_action('admin_init', 'SLIDE_SWP_events_admin_init');
function SLIDE_SWP_events_admin_init() 
{
	/* album information */
    add_meta_box('events_meta_box', 			/*the required HTML id attribute*/
        esc_html__('Event Settings','slide-music-core'), 		/*text visible in the heading of meta box section*/
        'SLIDE_SWP_display_events_meta_box',				/* callback FUNCTION which renders the contents of the meta box*/
        'js_events', 							/*the name of the custom post type where the meta box will be displayed*/
		'normal', 								/*defines the part of the page where the edit screen section should be shown*/
		'high' 									/*defines the priority within the context where the boxes should show*/
   );
}

function SLIDE_SWP_display_events_meta_box($eventObject) {
	$event_ID = $eventObject->ID;

    /* Retrieve current name of the custom fields album ID */
    $event_date = esc_html(get_post_meta($event_ID, 'event_date', true));
	$event_time = esc_html(get_post_meta($event_ID, 'event_time', true));
	$event_venue = esc_html(get_post_meta($event_ID, 'event_venue', true));
	$event_venue_url = esc_url(get_post_meta($event_ID, 'event_venue_url', true));	
	$event_location = esc_html(get_post_meta($event_ID, 'event_location', true));	
	$event_buy_tickets_message = esc_html(get_post_meta($event_ID, 'event_buy_tickets_message', true));		
	$event_buy_tickets_url = esc_url(get_post_meta($event_ID, 'event_buy_tickets_url', true));			
	$event_fb_message = esc_html(get_post_meta($event_ID, 'event_fb_message', true));
	$event_fb_url  = esc_url(get_post_meta($event_ID, 'event_fb_url', true));
	$event_map_url  = esc_html(get_post_meta($event_ID, 'event_map_url', true));
	$event_youtube_url  = esc_url(get_post_meta($event_ID, 'event_youtube_url', true));	
	$event_vimeo_url  = esc_url(get_post_meta($event_ID, 'event_vimeo_url', true));

	/*added starting with vers 1.7.1*/
	$event_multiday = esc_html(get_post_meta($event_ID, 'event_multiday', true));
	$event_end_date = esc_html(get_post_meta($event_ID, 'event_end_date', true));

	/*event canceled and sold out*/
	$event_canceled	 = esc_html(get_post_meta($event_ID, 'event_canceled', true));
	$event_sold_out	 = esc_html(get_post_meta($event_ID, 'event_sold_out', true));
	
	/*venue target*/
	$event_venue_target = esc_html(get_post_meta($event_ID, 'event_venue_target', true));
	if (empty($event_venue_target)) {
		$event_venue_target = "_self";
	}

	/*buy tickets target*/
	$event_buy_tickets_target = esc_html(get_post_meta($event_ID, 'event_buy_tickets_target', true));
	if (empty($event_buy_tickets_target)) {
		$event_buy_tickets_target = "_self";
	}

	$link_target_opts = array(
		esc_html__('Same Browser Window', 'slide-music-core')	=> '_self',
		esc_html__('New Browser Tab', 'slide-music-core')	=> '_blank'
	);	
?>

    <table style= "width: 100%;">
       <tr >
            <td style= "width: 30%;"><?php echo esc_html__('Event Date','slide-music-core');?></td>
			<td ><input class="swp_datepicker event_date_input" style="width: 100%;  display: block;" type="text" name="event_date" value="<?php echo esc_attr($event_date); ?>" />
				<div style="color: #999999; font-size: 0.9em; margin-bottom: 5px;"><?php echo esc_html__('The Date for Event YYYY/MM/DD','slide-music-core'); ?></div>
			</td>
        </tr>	
        <tr >
            <td style= "width: 30%;"><?php echo esc_html__('Event Time','slide-music-core');?></td>
            <td ><input id="timepicker" style="width: 100%;  display: block;" type="text" name="event_time" value="<?php echo esc_attr($event_time); ?>" />
				<div style="color: #999999; font-size: 0.9em; margin-bottom: 5px;"><?php echo esc_html__('Event Time hh:mm','slide-music-core'); ?></div>
			</td>
        </tr>
        <tr>
        	<td style= "width: 30%;"><?php echo esc_html__('Multi-Day Event','slide-music-core');?></td>
        	<td>
        		<input name="event_multiday" class="event_multiday_check" type="checkbox" value="1" <?php checked("1", $event_multiday); ?>>
        		<div style="color: #999999; font-size: 0.9em; margin-bottom: 5px;"><?php echo esc_html__('Check this ONLY if this is a multi day event.','slide-music-core'); ?></div>
        	</td>
        </tr>
       	<tr class="event_end_date_container">
            <td style= "width: 30%;"><?php echo esc_html__('Event End Date','slide-music-core');?></td>
			<td>
				<input class="swp_datepicker event_end_date_input" style="width: 100%;  display: block;" type="text" name="event_end_date" value="<?php echo esc_attr($event_end_date); ?>" />
				<div style="color: #999999; font-size: 0.9em; margin-bottom: 5px;">
					<?php echo esc_html__('The End Date for the Multi Day Event YYYY/MM/DD','slide-music-core'); ?>
				</div>
			</td>
        </tr>        
        <tr >
            <td style= "width: 30%;"><?php echo esc_html__('Event Venue','slide-music-core');?></td>
            <td ><input style="width: 100%;  display: block;" type="text" name="event_venue" value="<?php echo esc_attr($event_venue); ?>" />
				<div style="color: #999999; font-size: 0.9em; margin-bottom: 5px;"><?php echo esc_html__('Venue ex. Glastonbury Festival','slide-music-core'); ?></div>
			</td>
        </tr>
        <tr >
            <td style= "width: 30%;"><?php echo esc_html__('Venue URL','slide-music-core');?></td>
            <td ><input style="width: 100%;  display: block;" type="text" name="event_venue_url" value="<?php echo esc_attr($event_venue_url); ?>" />
				<div style="color: #999999; font-size: 0.9em; margin-bottom: 5px;"><?php echo esc_html__('Venue URL ex. http://www.glastonburyfestivals.co.uk/','slide-music-core'); ?></div>
			</td>
        </tr>

        <tr>
        	<td style= "width: 30%;"><?php echo esc_html__('Open Venue Link In','slide-music-core');?></td>
        	<td>
        		<select id="event_venue_target" name="event_venue_target">
        			<?php LMC_SWP_render_select_options($link_target_opts, $event_venue_target); ?>
        		</select>

        		<div style="color: #999999; font-size: 0.9em; margin-bottom: 5px;">
	        		<?php echo esc_html__('Choose to open venue link in self window or in a new tab.', 'slide-music-core'); ?>
        		</div>
        	</td>
        </tr>

        <tr >
            <td style= "width: 30%;"><?php echo esc_html__('Location','slide-music-core');?></td>
            <td ><input style="width: 100%;  display: block;" type="text" name="event_location" value="<?php echo esc_attr($event_location); ?>" />
				<div style="color: #999999; font-size: 0.9em; margin-bottom: 5px;"><?php echo esc_html__('Event Location ex. Worthy Farm, Pilton GB','slide-music-core'); ?></div>
			</td>
        </tr>		

        <tr >
            <td style= "width: 30%;"><?php echo esc_html__('Buy Tickets Message','slide-music-core');?></td>
            <td ><input  style="width: 100%;  display: block;" type="text" name="event_buy_tickets_message" value="<?php echo esc_attr($event_buy_tickets_message); ?>" />
				<div style="color: #999999; font-size: 0.9em; margin-bottom: 5px;"><?php echo esc_html__('ex. [Buy Tickets From] or [Free Entry]','slide-music-core'); ?></div>
			</td>
        </tr>		
        <tr >
            <td style= "width: 30%;"><?php echo esc_html__('Buy Tickets URL','slide-music-core');?></td>
            <td ><input style="width: 100%;  display: block;" type="text" name="event_buy_tickets_url" value="<?php echo esc_attr($event_buy_tickets_url); ?>" />
				<div style="color: #999999; font-size: 0.9em; margin-bottom: 5px;"><?php echo esc_html__('ex. http://www.ticketmaster.com/','slide-music-core'); ?></div>
			</td>
        </tr>		
        <tr>
        	<td style= "width: 30%;"><?php echo esc_html__('Open Tickets Link In','slide-music-core');?></td>
        	<td>
        		<select id="event_buy_tickets_target" name="event_buy_tickets_target">
        			<?php LMC_SWP_render_select_options($link_target_opts, $event_buy_tickets_target); ?>
        		</select>

        		<div style="color: #999999; font-size: 0.9em; margin-bottom: 5px;">
	        		<?php echo esc_html__('Choose to open tickets link in self window or in a new tab.', 'slide-music-core'); ?>
        		</div>
        	</td>
        </tr>        
        <tr >
            <td style= "width: 30%;"><?php echo esc_html__('Facebook Event Message','slide-music-core');?></td>
            <td ><input  style="width: 100%;  display: block;" type="text" name="event_fb_message" value="<?php echo esc_attr($event_fb_message); ?>" />
				<div style="color: #999999; font-size: 0.9em; margin-bottom: 5px;"><?php echo esc_html__('ex. Check event on Facebook','slide-music-core'); ?></div>
			</td>
        </tr>		
        <tr >
            <td style= "width: 30%;"><?php echo esc_html__('Facebook Event URL','slide-music-core');?></td>
            <td ><input  style="width: 100%;  display: block;" type="text" name="event_fb_url" value="<?php echo esc_attr($event_fb_url); ?>" />
				<div style="color: #999999; font-size: 0.9em; margin-bottom: 5px;"><?php echo esc_html__('URL to Facebook Event Page','slide-music-core'); ?></div>
			</td>
        </tr>		
        <tr >
            <td style= "width: 30%;"><?php echo esc_html__('Google Map Embed Code','slide-music-core');?></td>
            <td >
            <?php
				$allowed_html = array(
					'iframe' => array(
						'width' => array(),
						'height' => array(),
						'scrolling' => array(),
						'frameborder' => array(),
						'src' => array()
					)
				);
            ?>
            	<input  style="width: 100%;  display: block;" type="text" name="event_map_url" value="<?php echo wp_kses($event_map_url, $allowed_html); ?>" />
				<div style="color: #999999; font-size: 0.9em; margin-bottom: 5px;"><?php echo esc_html__('Embedded code ex. &lt;iframe src="https://www.google.com/maps/embed?pb=.." &gt;&lt;/iframe&gt;','slide-music-core'); ?></div>
			</td>
        </tr>		
        <tr >
            <td style= "width: 30%;"><?php echo esc_html__('Youtube URL','slide-music-core');?></td>
            <td ><input  style="width: 100%;  display: block;" type="text" name="event_youtube_url" value="<?php echo esc_attr($event_youtube_url); ?>" />
				<div style="color: #999999; font-size: 0.9em; margin-bottom: 5px;"><?php echo esc_html__('URL to Promo Video on Youtube','slide-music-core'); ?></div>
			</td>
        </tr>		
        <tr >
            <td style= "width: 30%;"><?php echo esc_html__('Vimeo URL','slide-music-core');?></td>
            <td ><input  style="width: 100%;  display: block;" type="text" name="event_vimeo_url" value="<?php echo esc_attr($event_vimeo_url); ?>" />
				<div style="color: #999999; font-size: 0.9em; margin-bottom: 5px;"><?php echo esc_html__('URL to Promo Video on Vimeo','slide-music-core'); ?></div>
			</td>
        </tr>
        <tr>
        	<td style= "width: 30%;"><?php echo esc_html__('Event Canceled','slide-music-core');?></td>
        	<td>
        		<input name="event_canceled" class="event_canceled_check" type="checkbox" value="1" <?php checked("1", $event_canceled); ?>>
        		<div style="color: #999999; font-size: 0.9em; margin-bottom: 5px;"><?php echo esc_html__('Check this if the event was canceled.','slide-music-core'); ?></div>
        	</td>
        </tr>
        <tr>
        	<td style= "width: 30%;"><?php echo esc_html__('Event Sold Out','slide-music-core');?></td>
        	<td>
        		<input name="event_sold_out" class="event_sold_out_check" type="checkbox" value="1" <?php checked("1", $event_sold_out); ?>>
        		<div style="color: #999999; font-size: 0.9em; margin-bottom: 5px;"><?php echo esc_html__('Check this if the event is sold out.','slide-music-core'); ?></div>
        	</td>
        </tr>        

	</table>
	
<?php
}

/* register save post function */
add_action('save_post', 'SLIDE_SWP_save_event_fields', 10, 2);

/*
	save post function - triggered on save 
	$event_id
	$eventObject
*/
function SLIDE_SWP_save_event_fields($event_id, $eventObject) 
{
	if ($eventObject->post_type != 'js_events') {
		return;
	}

	// Store data in post meta table if present in post data
	if (isset($_POST['event_date'])) {
		update_post_meta($event_id, 'event_date', $_POST['event_date']);
	}
	if (isset($_POST['event_time'])) {
		update_post_meta($event_id, 'event_time', $_POST['event_time']);
	}
	if (isset($_POST['event_venue'])) {
		update_post_meta($event_id, 'event_venue', $_POST['event_venue']);
	}
	if (isset($_POST['event_venue_url'])) {
		update_post_meta($event_id, 'event_venue_url', $_POST['event_venue_url']);
	}
	if (isset($_POST['event_location'])) {
		update_post_meta($event_id, 'event_location', $_POST['event_location']);
	}
	if (isset($_POST['event_buy_tickets_message'])) {
		update_post_meta($event_id, 'event_buy_tickets_message', $_POST['event_buy_tickets_message']);
	}
	if (isset($_POST['event_buy_tickets_url'])) {
		update_post_meta($event_id, 'event_buy_tickets_url', $_POST['event_buy_tickets_url']);
	}
	if (isset($_POST['event_fb_message'])) {
		update_post_meta($event_id, 'event_fb_message', $_POST['event_fb_message']);
	}
	if (isset($_POST['event_fb_url'])) {
		update_post_meta($event_id, 'event_fb_url', $_POST['event_fb_url']);
	}
	if (isset($_POST['event_map_url'])) {
		update_post_meta($event_id, 'event_map_url', $_POST['event_map_url']);
	}
	if (isset($_POST['event_youtube_url'])) {
		update_post_meta($event_id, 'event_youtube_url', $_POST['event_youtube_url']);
	}
	if (isset($_POST['event_vimeo_url'])) {
		update_post_meta($event_id, 'event_vimeo_url', $_POST['event_vimeo_url']);
	}
	if (isset($_POST['event_venue_target'])) {
		update_post_meta($event_id, 'event_venue_target', $_POST['event_venue_target']);
	}
	if (isset($_POST['event_buy_tickets_target'])) {
		update_post_meta($event_id, 'event_buy_tickets_target', $_POST['event_buy_tickets_target']);
	}

	if(isset($_POST['event_multiday'])) {
		update_post_meta($event_id, 'event_multiday', '1');
	} else {
		update_post_meta($event_id, 'event_multiday', '0');
	}
	if (isset($_POST['event_end_date'])) {
		update_post_meta($event_id, 'event_end_date', $_POST['event_end_date']);
	}

	if(isset($_POST['event_canceled'])) {
		update_post_meta($event_id, 'event_canceled', '1');
	} else {
		update_post_meta($event_id, 'event_canceled', '0');
	}
	
	if(isset($_POST['event_sold_out'])) {
		update_post_meta($event_id, 'event_sold_out', '1');
	} else {
		update_post_meta($event_id, 'event_sold_out', '0');
	}		
}

/*
	Adding custom columns to admin menu using filter  [manage_edit-{post_type}_columns]
*/
add_filter('manage_edit-js_events_columns', 'SLIDE_SWP_jamsession_events_admin_columns_func');
function SLIDE_SWP_jamsession_events_admin_columns_func($columns) {
	$columns = array(
		'cb'	=> '<input type="checkbox" />',
		'title' => esc_html__('Event Title', 'slide-music-core'),
		'event_date'	=>	__('Date', 'slide-music-core'),				
		'event_location' => esc_html__('Location', 'slide-music-core'),
		'event_venue'	=>	__('Venue', 'slide-music-core'),
		'author'	=> esc_html__('Author', 'slide-music-core'),
		'date'		=> esc_html__('Date', 'slide-music-core')		
	);
	
	return $columns;
}

/*
	Fill the custom columns on admin
*/

add_action('manage_js_events_posts_custom_column', 'SLIDE_SWP_manage_js_events_columns_func', 10, 2);
function SLIDE_SWP_manage_js_events_columns_func($column, $event_id) {
	global $post;
	
	switch($column) {
		case 'event_date' :
			$event_date = get_post_meta($event_id, 'event_date', true);
			echo esc_html($event_date);
			break;
		case 'event_location':
			$event_location = get_post_meta($event_id, 'event_location', true);
			echo esc_html($event_location);
			break;
		case 'event_venue':
			$event_venue = get_post_meta($event_id, 'event_venue', true);
			echo esc_html($event_venue);
			break;			
		default:
			break;
	}
}


/*
	Sortable column
*/
add_filter('manage_edit-js_events_sortable_columns', 'SLIDE_SWP_events_sortable_columns');
function SLIDE_SWP_events_sortable_columns($columns) {
  $columns['event_date'] = 'event_date';

  return $columns;
}

add_filter('request', 'SLIDE_SWP_events_columns_order_by');
function SLIDE_SWP_events_columns_order_by($vars) {
	if (isset($vars['orderby']) && 'event_date' == $vars['orderby']) {
	    $vars = array_merge( $vars, array(
	        'meta_key' => 'event_date',
	        'orderby' => 'meta_value'
	    ));
	}

	return $vars;
}

/*
	Create Category for Events
*/
add_action('init', 'SLIDE_SWP_create_event_category', 11);

function SLIDE_SWP_create_event_category()
{
	$slug = SLIDE_SWP_JPT_get_plugin_option("event_tax");
	if ("" == $slug) {
		$slug = "event_category";
	}
	
	register_taxonomy(
			'event_category',
			'js_events',
			array(
				'labels' => array(
					'name' => esc_html__('Event Categories', 'slide-music-core'),
					'singular_name'     => esc_html__('Event Category', 'slide-music-core'),
					'search_items'      => esc_html__('Search Event Categories', 'slide-music-core' ),
					'all_items'         => esc_html__('All Event Categories', 'slide-music-core' ),
					'parent_item'       => esc_html__('Parent Event Category', 'slide-music-core' ),
					'parent_item_colon' => esc_html__('Parent Event Category:', 'slide-music-core' ),
					'edit_item'         => esc_html__('Edit Event Category', 'slide-music-core' ),
					'update_item'       => esc_html__('Update Event Category', 'slide-music-core' ),
					'add_new_item' 		=> esc_html__('Add New Event Category', 'slide-music-core'),
					'new_item_name' 	=> esc_html__('New Event Category', 'slide-music-core'),
				),
				'rewrite' => array(
					'slug' => $slug,
					'with_front' => false
				),
				'show_ui' => true,
				'show_tagcloud' => false,
				'hierarchical' => true
			)
		);
}

?>