<?php 
function SLIDE_SWP_setup_admin_import_menu() {
	add_theme_page(
        'Import Slide Demos', 			/* page title*/
		'Slide Import Demos',  			/* menu title */
		'administrator',    				/*capability*/
        'slide_import_demo',  			/*menu_slug*/
		'SLIDE_SWP_import_page_settings'  /*function */
	);
}
add_action("admin_menu", "SLIDE_SWP_setup_admin_import_menu");


define("JS_SWP_PRINT_IMPORTER", false);

function SLIDE_SWP_import_page_settings() {
	global $GLOB_IMPORT_DEMOS;
?>
	<!-- Create a header in the default WordPress 'wrap' container -->  
    <div class="wrap">  
        <div id="icon-themes" class="icon32"></div>  
        <h2 class="import_demo_title">Import Slide Demos</h2>

			<?php if (!class_exists('woocommerce')) { ?>
		    <div class="notice notice-info is-dismissible">
		    	<p>
		        	<?php echo esc_html__('It looks like WooCommerce plugin is not active. ', 'slide');  ?>
		        </p>
		        <p>
		        	<?php echo esc_html__('If you plan to add a shop to your website, please install and activate WooCommerce before running the importer. ', 'slide'); ?>
		        </p>
		        <p>	
		        	<?php echo esc_html__('If you do not need to create a shop, please ignore and close this message.' , 'slide'); ?>
				</p>
		    </div>
		    <?php } ?>

			<?php if (!class_exists('RevSliderSlider')) { ?>
		    <div class="notice notice-warning is-dismissible">
		    	<p>
		        	<?php echo esc_html__('It looks like Revolution Slider plugin is not active.', 'slide');  ?>
		        </p>
		        <p>
		        	<?php echo esc_html__('Please activate Revolution Slider before running the importer, otherwise the importer process will not be able to import the demo slider. ', 'slide'); ?>
		        </p>
		    </div>
		    <?php } ?>


			<?php if (!class_exists('Vc_Manager')) { ?>
		    <div class="notice notice-warning is-dismissible">
		    	<p>
		        	<?php echo esc_html__('It looks like WPBakery Page Builder plugin is not active.', 'slide');  ?>
		        </p>
		        <p>
		        	<?php echo esc_html__('Please activate WPBakery Page Builder before running the importer. ', 'slide'); ?>
		        </p>
		    </div>
		    <?php } ?>

			<form method="post">
				<div class="available_demos">
					<div class="import_items">
						<?php
						$demoNo = 0;
						$DEMO_ON_ROW = 3;
						$IMG_URL = plugins_url('/img/', __FILE__);
						foreach ($GLOB_IMPORT_DEMOS as $demo) {
							if (!($demoNo % $DEMO_ON_ROW)) {
								if ($demoNo != 0) {
									echo '</div>';
								}
								
								echo '<div class="items_row clearfix">';
							}
						?>					
							<div class="items_cell">
								<img src="<?php echo esc_attr($IMG_URL.$demo['img']); ?>" alt="<?php  echo esc_attr($demo['name']); ?>">
								<button class="import_swp_demo_btn button button-primary" type="submit" data-importname="<?php echo esc_attr($demo['import_name']); ?>" data-importimg="<?php echo esc_attr($IMG_URL.$demo['img']); ?>">
									Import <?php  echo esc_attr($demo['name']); ?> Demo
								</button>
							</div>
							
						<?php					
							$demoNo++;
						}
						?>
						</div> <!-- latest .items_row -->
					</div> <!-- .import_items -->
				</div> <!-- .available_demos -->

				<input type="text" name="demo_to_import" id="demo_to_import" value=""/>
				<input type="text" name="demo_img_to_import" id="demo_img_to_import" value=""/>
				
				<div class="import_spinner">
					<img src="<?php echo plugins_url('/asset/spinner.gif', __FILE__);?>">
				</div>
			</form>

			<?php if (isset($_POST['demo_to_import'])) { ?>
				<div class="importer_overlay"></div>
			<?php } ?>
	</div> <!-- wrap-->		
		
	<hr class="after_demos">
	<?php  
	SLIDE_SWP_flush_buffer("");
	
	$import_name = "";
	if (isset($_POST['demo_to_import'])) {
		$import_name = $_POST['demo_to_import'];
	} else {
		return;
	}
	$import_img_preview = $_POST['demo_img_to_import'];

	?>	

	<div id="import_message">
		<div class="import_img_preview_run">
			<img src="<?php echo esc_attr($import_img_preview); ?>">
		</div>

		<?php 
			$importer_output = "";
			SLIDE_SWP_import_content_by_name($import_name, $importer_output);

			SLIDE_SWP_set_static_front_page($import_name);

			SLIDE_SWP_set_import_theme_settings($import_name);

			SLIDE_SWP_set_menu_location("Main Menu", "main-menu");

			SLIDE_SWP_import_slider($import_name);

			SLIDE_SWP_flush_buffer('<strong>Importer process finished <span class="swp_msg_ok no_padding">successfully</span>, <a href="'.home_url().'">go to the website</a> !</strong><br>');
		?>
	</div>
		
	<div id="js_swp_import_details">
		<?php
			if (!empty($importer_output)) {
				SLIDE_SWP_flush_buffer($importer_output);
			}
		?>
	</div>
<?php	
}

?>