<?php

function SLIDE_SWP_flush_buffer($str = "") {
	$allowed_tags = array(
		'br' 		=> array(),
		'strong'	=> array(),
		'span'		=> array(
				'class'	=> array()
		),
		'a'	=> array(
			'href'		=> array(),
			'target'	=> array()
		)
	);

	echo wp_kses($str, $allowed_tags);
    echo str_pad('',4096)."\n";
	ob_flush();
	flush();	
}

/*
	Import content from xml
*/
function SLIDE_SWP_import_content_by_name($import_name, &$importer_output) {
	$importer_output = "";
	
	SLIDE_SWP_flush_buffer('Preparing to import <strong class="import_name_run">' . $import_name . '</strong> demo... ');

	/*create the path to the xml file*/
	$import_file = CDIR_PATH.'/import/xml/'.$import_name.'/1.xml';
	
	if (!defined('WP_LOAD_IMPORTERS')) {
		define('WP_LOAD_IMPORTERS', true);
	}		
	require_once ABSPATH . 'wp-admin/includes/import.php';
	
	/*get WP_Importer from wordpress*/
	if (!class_exists('WP_Importer')) {
		$class_wp_importer = ABSPATH . 'wp-admin/includes/class-wp-importer.php';
		if (file_exists( $class_wp_importer)) {
			require_once($class_wp_importer);
		} else {
			$importer_error = true;
			SLIDE_SWP_flush_buffer("Could not locate class WP_Importer.<br>");
		}
	}

	/*get WP_Import*/
	if (!class_exists('WP_Import')) {
		require_once(CDIR_PATH."/import/lib/wordpress-importer.php");				
	}
	
	if(!is_file($import_file)){
		$errorLoc = "The XML file containing the dummy content located at: <br>".$import_file." <br>is not available or could not be read.<br>";
		$errorLoc .= " You might want to try to set the file permission to chmod 755.<br>";
		SLIDE_SWP_flush_buffer($errorLoc);
	} else {
		$wp_import = new WP_Import();
		$wp_import->fetch_attachments = true;			
		
		add_filter( 'import_post_meta_key', array( $wp_import, 'is_valid_meta_key' ) );
		add_filter( 'http_request_timeout', array( &$wp_import, 'bump_request_timeout' ) );
		
		SLIDE_SWP_flush_buffer("Starting the import process!");
		$wp_import->import_start($import_file);

		SLIDE_SWP_flush_buffer("<br>Importing author information... ");
		$wp_import->get_author_mapping();
		
		wp_suspend_cache_invalidation(true);
		
		SLIDE_SWP_flush_buffer('<span class="swp_msg_ok">Done!</span> <br>Importing post categories... ');
		
		ob_start();
		$wp_import->process_categories();
		$wp_import->process_tags();
		$wp_import->process_terms();
		$importer_output = ob_get_clean();
		
		SLIDE_SWP_flush_buffer('<span class="swp_msg_ok">Done!</span> <br>Importing content, please be patient, this might take a while<br>');
		
		/*ob_start();*/
		$wp_import->process_posts();
		/*$importer_output .= ob_get_clean();*/

		SLIDE_SWP_flush_buffer('<span class="swp_msg_ok">Done!</span> <br>');
		
		wp_suspend_cache_invalidation(false);

		/* update incorrect/missing information in the DB*/
		$wp_import->backfill_parents();
		$wp_import->backfill_attachment_urls();
		$wp_import->remap_featured_images();

		ob_start();
		$wp_import->import_end();
		$importer_output .= ob_get_clean();
		
		$wp_import->flag_as_imported['content'] = true;
	}	
}

/*
	Set static front page
*/
function SLIDE_SWP_set_static_front_page($importName) {
	global $GLOB_FRONT_PAGES;

	SLIDE_SWP_flush_buffer('Setting static front page for <strong>'.$importName.'</strong> demo... ');
	
	/* check if array elem exists */
	if (!array_key_exists($importName, $GLOB_FRONT_PAGES)) {
		SLIDE_SWP_flush_buffer('Incorrect demo import name when setting static front page: '.$importName.'<br>');
		return false;
	}
	
	/* Use a static front page */
	$pageObj = get_page_by_title($GLOB_FRONT_PAGES[$importName]);
	update_option('page_on_front', $pageObj->ID);
	update_option('show_on_front', 'page');
	
	SLIDE_SWP_flush_buffer('<span class="swp_msg_ok">Done!</span><br>');
	return true;
}

/*
	Import theme settings
*/
function SLIDE_SWP_set_import_theme_settings($importName) {
	global $GLOB_IMPORT_THEME_SETTINGS;

	SLIDE_SWP_flush_buffer('Importing theme settings for <strong>'.$importName.'</strong> demo... ');
	
	/* check if array elem exists */
	if (!array_key_exists($importName, $GLOB_IMPORT_THEME_SETTINGS)) {
		SLIDE_SWP_flush_buffer('Incorrect demo import name when setting static front page: '.$importName.'<br>');
		return false;
	}
	
	$themeOptionsArray = array();
	$themeOptionsArray = json_decode($GLOB_IMPORT_THEME_SETTINGS[$importName], true);
	
	/*
		Images set as file name, to be able to take the image from the own server
	*/
	if (!empty($themeOptionsArray['logo_upload_value'])) {
		$themeOptionsArray['logo_upload_value'] = SLIDE_SWP_get_img_url_by_name($themeOptionsArray['logo_upload_value']);
	}
	if (!empty($themeOptionsArray['bgimage_upload_value'])) {
		$themeOptionsArray['bgimage_upload_value'] = SLIDE_SWP_get_img_url_by_name($themeOptionsArray['bgimage_upload_value']);
	}	
	update_option('slide_theme_general_options', $themeOptionsArray);	
	
	/*update theme customizer options*/
	$customizerImportError = SLIDE_SWP_set_import_theme_customizer($importName);
	if ($customizerImportError != '') {
		SLIDE_SWP_flush_buffer($customizerImportError);
		return false;
	}

	SLIDE_SWP_flush_buffer('<span class="swp_msg_ok">Done!</span><br>');	
	return true;	
}

/*
	called from theme settings function - SLIDE_SWP_set_import_theme_settings
*/
function  SLIDE_SWP_set_import_theme_customizer($importName) {
	global $GLOB_IMPORT_THEME_CUSTOMIZER;
	global $GLOB_IMPORT_BG_COLOR;
	
	/* check if array elem exists */
	if (!array_key_exists($importName, $GLOB_IMPORT_THEME_CUSTOMIZER)) {
		return 'Incorrect demo import name when setting customizer options: '.$importName;
	}
	
	$themeCustomizerArray = array();
	$themeCustomizerArray = json_decode($GLOB_IMPORT_THEME_CUSTOMIZER[$importName], true);
	
	update_option('lc_customize', $themeCustomizerArray);

	/* check if array elem exists */
	if (!array_key_exists($importName, $GLOB_IMPORT_BG_COLOR)) {
		return 'Incorrect demo import name when setting background color: '.$importName;
	}
	$demo_bg_color = $GLOB_IMPORT_BG_COLOR[$importName];

	if (strlen($demo_bg_color)) {
		set_theme_mod('background_color', $demo_bg_color);
	}
	return '';
}

function SLIDE_SWP_set_menu_location($menu_name, $menu_location) {
	/*
	   Menu_Object (
		   term_id => 4
		   name => My Menu Name
		   slug => my-menu-name
		   term_group => 0
		   term_taxonomy_id => 4
		   taxonomy => nav_menu
		   description => 
		   parent => 0
		   count => 6
	   )
	*/
	SLIDE_SWP_flush_buffer('Setting menu location...');
	
	$menu_object = wp_get_nav_menu_object($menu_name);
	$locations = get_theme_mod('nav_menu_locations');
	$locations[$menu_location] = $menu_object->term_id;
	set_theme_mod('nav_menu_locations', $locations);

	SLIDE_SWP_flush_buffer('<span class="swp_msg_ok">Done!</span><br>');	
}

function SLIDE_SWP_import_slider($importName) {
	global $GLOB_IMPORT_SLIDERS;

	SLIDE_SWP_flush_buffer('Importing slider...');

	/* check if array elem exists */
	if (!array_key_exists($importName, $GLOB_IMPORT_SLIDERS)) {
		return 'Incorrect slider name for the demo: '.$importName;
	}	
	
	$slider_name = $GLOB_IMPORT_SLIDERS[$importName];

	/*get the path tp WP*/
	$absolute_path = __FILE__;
	$path_to_file = explode( 'wp-content', $absolute_path);
	$path_to_wp = $path_to_file[0];
	 
	/*require needed WP files*/
	require_once( $path_to_wp.'/wp-load.php' );
	require_once( $path_to_wp.'/wp-includes/functions.php');
	 
	/**/	 
	$slider_array = array(CDIR_PATH."/import/sliders/" . $slider_name);
	$slider = new RevSlider();
	 
	foreach($slider_array as $filepath){
		$slider->importSliderFromPost(true, true, $filepath);  
	}

	SLIDE_SWP_flush_buffer('<span class="swp_msg_ok">Done!</span><br>');

	return true;
}

function SLIDE_SWP_get_img_url_by_name($post_name) {
		$args = array(
            'post_per_page' => 1,
            'post_type'     => 'attachment',
            'name'          => trim($post_name),
        );
        $result = new WP_Query($args);
		$imageURL = "";
		if ($result->have_posts()) {
			$imageURL = wp_get_attachment_url($result->posts[0]->ID);
		}
       
		wp_reset_postdata();
		return $imageURL;
}