<?php
/**
 * Plugin Name: Slide Music Core
 * Plugin URI: http://www.smartwpress.com/
 * Description: This plugin adds custom post types and custom meta boxes used by Slide wordpress theme.
 * Version: 1.0.6
 * Author: SmartWpress
 * Author URI: http://www.smartwpress.com
 * Text Domain: slide-music-core
 * Domain Path: /languages
 * License: GNU General Public License version 3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
 
 
 /*
|--------------------------------------------------------------------------
| CONSTANTS
|--------------------------------------------------------------------------
*/
if (!defined('CDIR_PATH')) {
	define('CDIR_PATH', plugin_dir_path(__FILE__ ) );
}
if (!defined('CDIR_URL')) {
	define('CDIR_URL', plugin_dir_url(__FILE__ ) );
}

/* 
|--------------------------------------------------------------------------
| INCLUDE FUNCTIONALITY
|--------------------------------------------------------------------------
*/

/* 
	Plugin Settings
*/
require_once(CDIR_PATH."/settings/smc_plugin_settings.php");

/*
	Utils
*/
require_once(CDIR_PATH."/include/utils.php");

/*
	Custom Post Types 
*/
require_once(CDIR_PATH."/custom_posts/videos.php");
require_once(CDIR_PATH."/custom_posts/photo_albums.php");
require_once(CDIR_PATH."/custom_posts/albums.php");
require_once(CDIR_PATH."/custom_posts/events.php");
require_once(CDIR_PATH."/custom_posts/artist.php");

/*
	Custom post meta
*/
require_once(CDIR_PATH."/custom_meta/custom_meta_boxes.php");

/*
	Widgets
*/
require_once(CDIR_PATH."/widgets/slide_widgets.php");

/*
	Visual Composer Elements
*/
require_once(CDIR_PATH."/visual_composer/add_remove_params.php");	/*add remove params for some visual composer elements*/
require_once(CDIR_PATH."/visual_composer/add_shortcodes.php");		/*add new shortcodes to be used by visual composer*/
require_once(CDIR_PATH."/visual_composer/vc_map.php");				/*map existing shortcodes to vc elements*/

/*
	AJAX functions
*/
require_once(CDIR_PATH."/include/ajax_binding.php");

/*
	Slide Demo Importer
*/
require_once(CDIR_PATH."/import/slide_import.php");

/* 
|--------------------------------------------------------------------------
| LOAD TEXT DOMAIN
|--------------------------------------------------------------------------
*/
/*
	Load text domain
*/
function SLIDE_SWP_slide_music_core_init() {
	$domain = "slide-music-core";
	$locale = apply_filters('plugin_locale', get_locale(), $domain );
	$trans_location = trailingslashit(WP_LANG_DIR ) . "plugins/" . $domain . '-' . $locale . '.mo';
	
	/*
		ex: wp-content/languages/plugins/slide-music-core-es_ES.mo
	*/
	if ($loaded = load_plugin_textdomain($domain, FALSE, $trans_location) ) {
		return $loaded;
	} else {
		/*
		old location, languages dir in the plugin dir
		ex: slide-music-core/languages/es_ES.mo
		*/
		load_plugin_textdomain($domain, FALSE, basename(dirname(__FILE__ ) ) . '/languages/');
	}
}
add_action('init', 'SLIDE_SWP_slide_music_core_init');


/* 
|--------------------------------------------------------------------------
| LOAD SCRIPTS AND STYLES
|--------------------------------------------------------------------------
*/
/*
	Load scripts and styles
*/
function SLIDE_SWP_plugin_load_scripts_and_styles() {
	/*photo gallery css*/
	wp_register_style('js_gallery_post_admin', plugins_url('/css/js_gallery_post_admin.css', __FILE__));
	wp_enqueue_style('js_gallery_post_admin');

	/*photo gallery js*/
	wp_register_script('handle_image_actions', plugins_url('/js/handle_image_actions.js', __FILE__), array(), '', true);
	wp_enqueue_script('handle_image_actions');	

	wp_register_script('media_upload_assets', plugins_url('/js/media_upload_assets.js', __FILE__), array(), '', true);
	wp_enqueue_script('media_upload_assets');	

	/*generic admin css*/
	wp_register_style('js_backend_css', plugins_url('/css/backend_style.css', __FILE__));
	wp_enqueue_style('js_backend_css');
	
	/*audio admin css*/
	wp_register_style('js_audio_styles',  plugins_url('/css/js_audio_styles.css', __FILE__));
	wp_enqueue_style('js_audio_styles');

	/*discography js*/
	wp_register_script('handle_audio_actions', plugins_url('/js/handle_audio_actions.js', __FILE__), array(), '', true);
	wp_enqueue_script('handle_audio_actions');		
	
	/*time picker jQuery plugin css and js*/
	wp_register_style('jquery.ui.timepicker', plugins_url('/css/jquery.ui.timepicker.css', __FILE__ ));
	wp_enqueue_style('jquery.ui.timepicker');

	wp_register_script('jquery.ui.timepicker', plugins_url('/js/jquery.ui.timepicker.js', __FILE__), array('jquery'), '', true);
	wp_enqueue_script('jquery.ui.timepicker');	
	
	/*date picker jQuery plugin and style*/
	wp_enqueue_script('jquery-ui-datepicker');
	wp_enqueue_style('jquery-style', plugins_url('/css/jquery-ui.css', __FILE__));

	/*initialise date picker*/
	wp_register_script('initialize_datepicker', plugins_url('/js/initialize_datepicker.js', __FILE__), array('jquery-ui-datepicker', 'jquery.ui.timepicker'), '', true);
	wp_enqueue_script('initialize_datepicker');
	
	/*alpha color picker*/
	wp_register_script('alpha_color_picker', plugins_url('/js/alpha-color-picker.js', __FILE__), array('jquery', 'wp-color-picker'), '', true);
	wp_enqueue_script('alpha_color_picker');
	wp_enqueue_style('alpha_color_picker', plugins_url('/css/alpha-color-picker.css', __FILE__ ), array('wp-color-picker'));

	/*general cpt js*/
	wp_register_script('swp_cpt_js', plugins_url('/js/swp_cpt.js', __FILE__), array('jquery'), '', true);
	wp_enqueue_script('swp_cpt_js');			
}
add_action('admin_enqueue_scripts', 'SLIDE_SWP_plugin_load_scripts_and_styles');


function SLIDE_SWP_plugin_load_front_scripts_and_styles() {
	/*contact form action*/
	wp_register_script('lc_swp_contact_form', plugins_url('/js/lc_swp_contact_form.js', __FILE__), array('jquery'), '', true);
	wp_enqueue_script('lc_swp_contact_form');

	/*set ajax url*/
	$ajaxurl_val = array(
		'ajaxurl' => admin_url('admin-ajax.php' )
	);
	wp_localize_script('lc_swp_contact_form', 'DATAVALUES', $ajaxurl_val);	
}
add_action('wp_enqueue_scripts', 'SLIDE_SWP_plugin_load_front_scripts_and_styles');


/*
 Set Default Visual Composer Editor
*/
if (function_exists("vc_set_default_editor_post_types")) {
	$posts_support_vc = array(
	    'page',
	    'js_artist'
	);
	vc_set_default_editor_post_types($posts_support_vc);
}

/*
	Add sharing icons at the end of the posts
*/

add_filter('the_content', 'SLIDE_SWP_add_sharing_icons', 20); 
function SLIDE_SWP_add_sharing_icons($content) {
	if (!SLIDE_SWP_is_sharing_visible()) {
		return $content;
	}
	if (!is_singular(
		array("js_albums", "js_events", "js_photo_albums", "js_videos", "post")) && 
		!is_page_template("default")) {
		return $content;
	}
	/*for some reason, singular("js_artist") is resolved as is_page_template("default")*/
	if (is_singular("js_artist")) {
		return $content;
	}
	if (function_exists("is_product") && is_product()) {
		return $content;
	}

	$permalink = get_permalink();
	$title = get_the_title();
	$image = '';
	if(function_exists('the_post_thumbnail')) {
			$image =  wp_get_attachment_url(get_post_thumbnail_id());
	}

	ob_start();
	?>
	<div class="clearfix"></div>
	<div class="lc_sharing_icons">
		<span class="lc_share_item_text"><?php echo esc_html__('Share:', 'slide-music-core')?></span>
		<a href="https://twitter.com/intent/tweet?url=<?php echo urlencode(esc_url($permalink)); ?>" target="_blank" class="lc_share_item">
			<i class="fab fa-twitter" aria-hidden="true"></i>
		</a>	

		<a href="http://www.facebook.com/sharer/sharer.php?u=<?php  echo urlencode(esc_url($permalink)); ?>" target="_blank" class="lc_share_item">
			<i class="fab fa-facebook-f" aria-hidden="true"></i>
		</a>

		<a href="https://plus.google.com/share?url=<?php echo urlencode(esc_url($permalink)); ?>" target="_blank" class="lc_share_item">
			<i class="fab fa-google-plus-g" aria-hidden="true"></i>
		</a>	

		<?php if (!empty($image)) {?>
		<a href="http://pinterest.com/pin/create/button/?url=<?php echo urlencode(esc_url($permalink)).'&amp;media='.$image; ?>" target="_blank" class="lc_share_item">
			<i class="fab fa-pinterest-p" aria-hidden="true"></i>
		</a>
		<?php } ?>
	</div>
	<?php

	$output_sharing_icons = ob_get_clean();
	return $content . $output_sharing_icons;
}

/* 
|--------------------------------------------------------------------------
| FLUSH REWRITE RULES
|--------------------------------------------------------------------------
*/
/*
	Flush rewrite rules on activation/deactivation
	Needed by the functionality that renames the slug for custom post types and taxonomies for custom post types
*/
function SLIDE_SWP_activate() {
	flush_rewrite_rules();
}
register_activation_hook(__FILE__, 'SLIDE_SWP_activate');

function SLIDE_SWP_deactivate() {
	flush_rewrite_rules();
}
register_deactivation_hook(__FILE__, 'SLIDE_SWP_deactivate');


/* 
|--------------------------------------------------------------------------
| GET PLUGIN OPTION
|--------------------------------------------------------------------------
*/
/*
	Retreive plugin options
*/
function SLIDE_SWP_JPT_get_plugin_option($option) {
	$options = get_option('SMC_plugin_options');
	
	if (isset($options[$option])) {
		return $options[ $option ];
	}
	
	return "";
}

function SLIDE_SWP_LMC_get_contact_form_email() {
	$options = get_option('SMC_plugin_options');

	$cf_email = '';
	if (isset($options['lc_mc_contact_form_email'])) {
		$cf_email = sanitize_email($options['lc_mc_contact_form_email']);
	}

	if ("" == $cf_email) {
		$cf_email = get_option("admin_email");
	}
	
	return $cf_email;
}

/*
	Change default template directory for WPBakery Page Builder
*/
add_action('vc_before_init', 'SLIDE_SWP_set_vc_templates_dir');
function SLIDE_SWP_set_vc_templates_dir() {
    if (function_exists('vc_set_shortcodes_templates_dir')) { 
        vc_set_shortcodes_templates_dir(CDIR_PATH."/visual_composer/vc_templates");
    }	
}

?>