<?php
/*
	Section Heading
*/
add_shortcode('swp_row_heading', 'SLIDE_SWP_swp_row_heading');
function SLIDE_SWP_swp_row_heading($atts) {
	/* base64_encode('Section  Heading')) = "U2VjdGlvbiBUaXRsZQ==" */
	$defaults = array(
		'title' 				=> "U2VjdGlvbiBUaXRsZQ==",
		'text_align'			=> "text_center",	/*text_center/text_left/text_right*/
		'font_weight' 				=> "",	/*fw_900(default), fw_700*/
		'font_preset' 				=> "big_size"	/*big_size(48px), medium_size(40px)*/
	);
	extract(shortcode_atts($defaults, $atts));

	$title = urldecode(base64_decode($title));

	$allowed_html = array(
			'span'	=> array(
					'class'	=> array()
				),
			'strong'=> array(),
			'br'	=> array()
		);

	$element_class = "swp_vc_section_title " . $text_align . " " . $font_weight;
	ob_start();
	?>

	<div class="<?php echo esc_attr($element_class); ?>">
		<h2 class="section_title <?php echo esc_attr($font_preset);?>"><?php echo wp_kses($title, $allowed_html); ?></h2>
	</div>
	
	<?php	
	$output = ob_get_clean();
	
	return $output;
}

/*
	Column Heading
*/
add_shortcode('swp_col_heading', 'SLIDE_SWP_swp_col_heading');
function SLIDE_SWP_swp_col_heading($atts) {
	/* base64_encode('Send Me A Message')) = "U2VuZCBNZSBBIE1lc3NhZ2U=" */
	$defaults = array(
		'title' 				=> "U2VuZCBNZSBBIE1lc3NhZ2U=",
		'text_align'			=> "text_left"	/*text_center/text_left/text_right*/
	);
	extract(shortcode_atts($defaults, $atts));

	$title = urldecode(base64_decode($title));

	$allowed_html = array(
			'span'	=> array(
					'class'	=> array()
				),
			'strong'=> array(),
			'br'	=> array()
		);

	ob_start();
	?>

	<div class="swp_vc_column_title <?php echo esc_attr($text_align); ?>">
		<h3 class="swp_column_title"><?php echo wp_kses($title, $allowed_html); ?></h2>
	</div>
	
	<?php	
	$output = ob_get_clean();
	
	return $output;
}

add_shortcode('swp_row_subtitle', 'SLIDE_SWP_swp_row_subtitle');
function SLIDE_SWP_swp_row_subtitle($atts) {
	$defaults = array(
		'text_content' 		=> "Follow our amazing shows",
		'align'				=> "text_center",	/*text_left, text_center, text_right*/
		'text_color'		=> "color_default",	/*color_default, color_vibrant, color_custom*/
		"user_color"		=> "#ffffff",
		'bottom_margin'		=> "default_margin"	/*default_margin, no_margin*/
	);
	extract(shortcode_atts($defaults, $atts));

	$elt_class = "swp_row_subtitle_scd " . $align;
	if ("color_vibrant" == $text_color) {
		$elt_class .= " vibrant_color";
	}
	if ("no_margin" == $bottom_margin) {
		$elt_class .= " no_margin";
	}
	if ("color_custom" == $text_color) {
		$elt_class .= " swp_cust_txt_col";
	}
	ob_start();
	?>

	<div class="<?php echo esc_attr($elt_class); ?>" data-txtcol="<?php echo esc_attr($user_color); ?>">
		<?php echo esc_html($text_content); ?>
	</div>
	
	<?php
	$output = ob_get_clean();
	return $output;
}

add_shortcode('swp_latest_albums', 'SLIDE_SWP_swp_latest_albums_scd');
function SLIDE_SWP_swp_latest_albums_scd($atts) {
	$defaults = array(
		'albumsnumber' 			=> '5',
		'album_category'		=> '0',
		'artist_id' 			=> '0',
		'emphasize_first'		=> 'yes'	/*yes/no*/
	);
	extract(shortcode_atts($defaults, $atts));

	//'albums_on_row' 		=> '3',
	$args = array(
		'numberposts'	=> $albumsnumber,
		'posts_per_page'   => $albumsnumber,
		'orderby'          => 'meta_value',
		'meta_key'         => 'album_release_date',		
		'order'            => 'DESC',
		'post_type'        => 'js_albums',
		'post_status'      => 'publish',
		'suppress_filters' => false
	);

	if ("0" != $artist_id) {
		$args['meta_query'] = array(
			array(
				'key' => 'swp_artist_selection',
				'value' => $artist_id,
				'compare' => 'LIKE'
			)
		);
	}

	/*album category filter*/
	if (('0' != $album_category) && strlen($album_category)) {
		$args["tax_query"] = array(
				array(
					'taxonomy' => 'album_category',
					'field'    => 'term_id',
					'terms'    => $album_category,
				)
			);
	}

	$wp_query= null;
	$wp_query = new WP_Query();
	$wp_query->query($args);

	ob_start();

	if ($wp_query->have_posts()) {

		$container_class = 'lc_swp_boxed lc_basic_content_padding clearfix';
		if ("yes" == $emphasize_first) {
			$container_class .= " emphasize_first_album";
		}
		$items_on_row = 4;
		$item_count = 0;
		?>

		<div class="<?php echo esc_attr($container_class); ?>">
			<?php
			while ($wp_query->have_posts()) {
				$wp_query->the_post();
				$item_count++;
				$item_class= "latest_albums_single swp_custom_ar ar_square lc_swp_background_image";

				if (("yes" == $emphasize_first) && ($item_count <= 5)) {
					$has_right_padding = in_array($item_count, array(3, 5)) ? '' : ' has_right_padding';
				} else {
					$has_right_padding = (0 == $item_count % $items_on_row) ? '' : ' has_right_padding';
				}

				if (strlen($has_right_padding)) {
					$item_class .= " has_right_padding";
				}
				$bg_img_url = "";
				if (has_post_thumbnail()) {
						$bg_img_url = get_the_post_thumbnail_url('', 'full');
				}

				$album_buy_message1 = esc_html(get_post_meta(get_the_ID(), 'album_buy_message1', true)); 			
				$album_buy_link1 = esc_html(get_post_meta(get_the_ID(), 'album_buy_link1', true));
				$album_release_date = esc_html(get_post_meta(get_the_ID(), 'album_release_date', true));
				@$album_release_date = str_replace("/","-", $album_release_date);
				try {
					@$output_date = new DateTime($album_release_date);	
				} catch(Exception $e) {
					@$output_date = new DateTime('NOW');
				}
				$album_title = get_the_title();
				?>

				<div class="<?php echo esc_attr($item_class); ?>" data-bgimage="<?php echo esc_url($bg_img_url); ?>">
					<div class="latest_albums_overlay transition3"></div>

					<div class="latest_albums_scd_content transition3">
						<div class="album_scd_date">
							<?php echo date_i18n("M Y", $output_date->format('U')); ?>
						</div>
						<h3 class="album_scd_title">
							<a href="<?php the_permalink(); ?>" class="album_scd_link">
								<?php echo esc_html($album_title); ?>
							</a>	
						</h3>
						<div class="album_scd_buy_container">
							<a href="<?php echo esc_url($album_buy_link1); ?>" target="_blank" class="album_scd_link">
								<?php echo esc_html($album_buy_message1); ?>
							</a>
						</div>						
					</div>
				</div>

			<?php } ?>
		</div>
	<?php }

	wp_reset_query();
	wp_reset_postdata();	
	
	$output = ob_get_clean();
	return $output;		
}

add_shortcode('swp_latest_albums_vinyl', 'SLIDE_SWP_swp_latest_albums_vinyl_scd');
function SLIDE_SWP_swp_latest_albums_vinyl_scd($atts) {
	$defaults = array(
		'albumsnumber' 			=> '3',
		'album_category'		=> '0',
		'artist_id' 			=> '0'
	);
	extract(shortcode_atts($defaults, $atts));

	$args = array(
		'numberposts'	=> $albumsnumber,
		'posts_per_page'   => $albumsnumber,
		'orderby'          => 'meta_value',
		'meta_key'         => 'album_release_date',		
		'order'            => 'DESC',
		'post_type'        => 'js_albums',
		'post_status'      => 'publish',
		'suppress_filters' => false
	);

	if ("0" != $artist_id) {
		$args['meta_query'] = array(
			array(
				'key' => 'swp_artist_selection',
				'value' => $artist_id,
				'compare' => 'LIKE'
			)
		);
	}

	/*album category filter*/
	if (('0' != $album_category) && strlen($album_category)) {
		$args["tax_query"] = array(
				array(
					'taxonomy' => 'album_category',
					'field'    => 'term_id',
					'terms'    => $album_category,
				)
			);
	}

	$wp_query= null;
	$wp_query = new WP_Query();
	$wp_query->query($args);

	$container_class = 'lc_swp_boxed lc_basic_content_padding discography_template_container';
	$items_on_row = 3;
	$vinyl_src = CDIR_URL . "/img/slide_record.png";
	$item_count = 0;

	ob_start();

	if ($wp_query->have_posts()) {
	?>	
		<div class="<?php echo esc_attr($container_class); ?>">
			<div class="albums_container swp_vc_element clearfix">
				<?php
				while ($wp_query->have_posts()) : $wp_query->the_post();
					$item_count++;

					$has_right_padding = (0 == $item_count % $items_on_row) ? '' : ' has_right_padding';
					$bg_img_url = has_post_thumbnail() ? get_the_post_thumbnail_url('', 'full') : "";
					$custom_css_class = ' albums_' . $items_on_row . "_on_row";
					?>

					<div class="single_album_item swp_vc_element <?php echo esc_attr($has_right_padding).esc_attr($custom_css_class); ?>">
						<a href="<?php the_permalink();?>">
							<div class="image_vinyl_container">
								<div class="album_image_container lc_swp_background_image" data-bgimage="<?php echo esc_url($bg_img_url); ?>">
								</div>
								<div class="slide_vinyl transition4">
									<img alt="<?php the_title(); ?>" src="<?php echo esc_url($vinyl_src); ?>">
									<img src="<?php echo esc_url($bg_img_url); ?>" class="image_on_vinyl">
								</div>
							</div>
							
							<div class="album_details">
								<h3 class="album_title album_heading transition4"> <?php the_title(); ?> </h3>
								<div class="album_cat_list">
									<?php
									if (has_term('', "album_category")) {
										the_terms("", "album_category", '', ' ', '');	
									}
									?>
								</div>			
							</div>
						</a>
					</div>
				<?php endwhile; ?>
			</div>
		</div>
	<?php
	}

	$output = ob_get_clean();
	return $output;	
}


add_shortcode('swp_event_countdown', 'SLIDE_SWP_swp_event_countdown_scd');
function SLIDE_SWP_swp_event_countdown_scd($atts) {
	$defaults = array(
		'countdown_text' 		=> "Next Big Show",
		'overlap_prev'			=> '',	/*overlap_prev/no_overlap*/
		'layout_style'			=> ''		/*vibrant_bg (default), transparent_bg*/
		);
	extract(shortcode_atts($defaults, $atts));

	$args = array(
		'numberposts'	=> 1,
		'posts_per_page'   => 1,
		'orderby'          => array('event_date' => 'ASC', 'event_time' => 'ASC'),
		'order'            => 'ASC',
		'meta_key'         => 'event_date',
		'post_type'        => 'js_events',
		'post_status'      => 'publish',
		'suppress_filters' => false,
		'meta_query' 		=> array(
			'relation' => 'AND',
			'event_date' => array(
			   'key' => 'event_date',
			   'value' => date('Y/m/d',current_time('timestamp')),
			   'compare' => '>='
			),
			'event_time' => array(
			   'key' => 'event_time'
			)
		)
	);

	$wp_query= null;
	$wp_query = new WP_Query();
	$wp_query->query($args);


	ob_start();

	if ($wp_query->have_posts()) {
		while($wp_query->have_posts()) {
			$wp_query->the_post();
			
			$event_id = get_the_ID();
			$event_title = get_the_title();
			$event_venue = esc_html(get_post_meta($event_id, 'event_venue', true));
			$event_buy_tickets_message = esc_html(get_post_meta($event_id, 'event_buy_tickets_message', true));
			$event_buy_tickets_url = esc_html(get_post_meta($event_id, 'event_buy_tickets_url', true));
			$event_date = esc_html(get_post_meta($event_id, 'event_date', true));
			$event_time = esc_html(get_post_meta($event_id, 'event_time', true));			
			if (strlen($event_time)) {
				$build_time = $event_date." ".$event_time.":00";	
			} else {
				$build_time = $event_date;
			}

			if (strtotime($build_time)) {
				$final_date =  new DateTime($build_time);
			}
			$time_attr = $final_date->format("D, d M y H:i:s");
			

			?>
			<div class="swp_event_countdown lc_swp_boxed clearfix <?php echo esc_attr($overlap_prev . " " . $layout_style); ?>" data-todate="<?php echo esc_attr($time_attr); ?>">
				<div class="event_countdown_details ec_inline">
					<div class="ec_user_text"><?php echo esc_html($countdown_text); ?></div>
					<div class="ec_title">
						<a href="<?php the_permalink(); ?>" class="ec_title_link">
							<?php echo esc_html($event_title); ?>
						</a>
					</div>
					<div class="ec_venue"><?php echo esc_html($event_venue); ?></div>
				</div>

				<div class="event_countdown_timer ec_inline clearfix">
					<div class="event_countdown_timer_inner">
						<div class="ec_days ec_timer_entry ec_inline">
							<div class="days_amount ec_amount">00</div>
							<span class="countdown_timer_word"><?php echo esc_html__("Days", "slide-music-core"); ?></span>
						</div>
						<div class="ec_hours ec_timer_entry ec_inline">
							<div class="hours_amount ec_amount">00</div>
							<span class="countdown_timer_word"><?php echo esc_html__("Hrs", "slide-music-core"); ?></span>
						</div>
						<div class="ec_mins ec_timer_entry ec_inline">
							<div class="mins_amount ec_amount">00</div>
							<span class="countdown_timer_word"><?php echo esc_html__("Mins", "slide-music-core"); ?></span>
						</div>
						<div class="ec_seconds ec_timer_entry ec_inline">
							<div class="seconds_amount ec_amount">00</div>
							<span class="countdown_timer_word"><?php echo esc_html__("Secs", "slide-music-core"); ?></span>
						</div>
					</div>
				</div>

				<div class="event_countdown_tickets ec_inline ec_countdown_buy">
					<?php if (strlen($event_buy_tickets_message)) { ?>
						<a href="<?php echo esc_url($event_buy_tickets_url); ?>" target="_blank" class="ec_title_link">
							<?php echo esc_html($event_buy_tickets_message); ?>
						</a>
					<?php } ?>
				</div>
			</div>
			<?php
		}
	}

	$output = ob_get_clean();
	return $output;
}

/*
	Slide Link
*/
add_shortcode('swp_slide_link', 'SLIDE_SWP_swp_slide_link');
function SLIDE_SWP_swp_slide_link($atts) {
	$defaults = array(
		'link_text' 		=> "view more",
		'link_url'			=> "#",
		'link_target'		=> "_self",	/*_self, _blank*/
		'text_align'		=> "text_center",	/*text_center/text_left/text_right*/
		'show_arrow'		=> "show_arrow"	/*show_arrow/no_arrow*/
	);
	extract(shortcode_atts($defaults, $atts));

	$elt_class = "swp_slide_link ". $text_align. " " . $show_arrow;
 
	ob_start();
	?>

	<div class="<?php echo esc_attr($elt_class); ?>">
		<a href="<?php echo esc_attr(esc_url($link_url)); ?>" target="<?php echo esc_attr($link_target); ?>" class="vibrant_color">
			<?php echo esc_html($link_text); ?>
			<?php if ("show_arrow" == $show_arrow) { ?>
				<i class="fas fa-arrow-right" aria-hidden="true"></i>
			<?php } ?>
		</a>
	</div>

	<?php	
	$output = ob_get_clean();
	
	return $output;
}

/*
	Slide Button
*/
add_shortcode('swp_slide_button_scd', 'SLIDE_SWP_swp_slide_button_scd');
function SLIDE_SWP_swp_slide_button_scd($atts) {
	$defaults = array(
		'btn_text'				=> 'view more',
		'btn_link'				=> '',
		'btn_txt_col'			=> '#ffffff',
		'btn_bg_col'			=> '#fb3a64',
		'btn_border_col'		=> '#fb3a64',
		'btn_txt_hover_col'		=> '#ffffff',
		'btn_bg_hover_col'		=> '',
		'btn_border_hover_col'	=> '#fb3a64',
		'btn_center'			=> 'text_center', /*text_left, text_right, text_center*/
		'btn_corners'			=> 'btn_square'	/*btn_square, btn_rounded*/
	);
	extract(shortcode_atts($defaults, $atts));

	if (function_exists("vc_build_link")) {
		$vc_link = vc_build_link($btn_link);
		$target = strlen($vc_link['target']) ? $vc_link['target'] : "_self";
		$url = strlen($vc_link['url']) ? $vc_link['url'] : "#";
	} else {
		$target = "_blank"; 
		$url = "#";
	}

	ob_start();
	?>

	<div class="swp_slide_btn_container <?php echo esc_attr($btn_center); ?>">
		<div class="swp_slide_btn <?php echo esc_attr($btn_corners); ?>" data-bc="<?php echo esc_attr($btn_txt_col); ?>" data-bbc="<?php echo esc_attr($btn_bg_col); ?>" data-bbdc="<?php echo esc_attr($btn_border_col); ?>" data-bhc="<?php echo esc_attr($btn_txt_hover_col); ?>" data-bbhc="<?php echo esc_attr($btn_bg_hover_col); ?>" data-bbdhc="<?php echo esc_attr($btn_border_hover_col); ?>">
			<a href="<?php echo esc_attr(esc_url($url)); ?>" target="<?php echo esc_attr($target); ?>">
				<?php echo esc_html($btn_text); ?>
			</a>
		</div>
	</div>

	<?php
	$output = ob_get_clean();
	return $output;
}

/*
	Video
*/
add_shortcode('swp_single_video', 'SLIDE_SWP_swp_single_video');
function SLIDE_SWP_swp_single_video($atts) {
	$defaults = array(
		'video_id' 		=> '',
		'use_bg_img'	=> 'post_thumbnail', /*post_thumbnail, custom*/
		'custom_bg_img'	=> ''
	);
	extract(shortcode_atts($defaults, $atts));

	$my_video = get_post($video_id);

	$video_youtube = esc_html(get_post_meta($video_id, 'video_youtube_url', true)); 			
	$video_vimeo = esc_html(get_post_meta($video_id, 'video_vimeo_url', true));

	if ( empty($video_youtube) && empty($video_vimeo)) {
		return "";
	}

	$youtube_id = $vimeo_id = "";
	if (function_exists("SLIDE_SWP_getIDFromShortURL")) {
		$youtube_id = SLIDE_SWP_getIDFromShortURL($video_youtube);
		$vimeo_id = SLIDE_SWP_getIDFromShortURL($video_vimeo);	
	}

	$vsource = empty($video_youtube) ? "vimeo"	: "youtube";
	$vid = "youtube" == $vsource ? $youtube_id : $vimeo_id;

	$img_url = get_the_post_thumbnail_url($video_id, 'full');
	if ("custom" == $use_bg_img) {
		$img_url = wp_get_attachment_url(trim($custom_bg_img));
	}

	ob_start();

	?>

	<div class="lc_swp_boxed swp_video_scd relative_pos lc_swp_background_image swp_custom_ar ar_169" data-bgimage="<?php echo esc_attr(esc_url($img_url)); ?>" data-vsource="<?php echo esc_attr($vsource); ?>" data-vid="<?php echo esc_attr($vid); ?>">
		<div class="video_scd_btn_play">
			<i class="fas fa-play video_scd_play_icon" aria-hidden="true"></i>
		</div>
	</div>

	<?php	

	$output = ob_get_clean();
	return $output;
}

add_shortcode('swp_video_btn', 'SLIDE_SWP_swp_video_btn_scd');
function SLIDE_SWP_swp_video_btn_scd($atts) {
	$defaults = array(
		'video_youtube' 		=> '',
		'video_vimeo'			=> '',
		'button_text'			=> 'Watch Now',
		'css'					=> ''
	);
	extract(shortcode_atts($defaults, $atts));
	$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class($css, ' ' ), 'swp_video_btn', $atts);

	if (empty($video_youtube) && empty($video_vimeo)) {
		return "";
	}
	
	$youtube_id = $vimeo_id = "";
	if (function_exists("SLIDE_SWP_getIDFromShortURL")) {
		$youtube_id = SLIDE_SWP_getIDFromShortURL($video_youtube);
		$vimeo_id = SLIDE_SWP_getIDFromShortURL($video_vimeo);	
	}

	$vsource = empty($video_youtube) ? "vimeo"	: "youtube";
	$vid = "youtube" == $vsource ? $youtube_id : $vimeo_id;

	ob_start();

	?>

	<div class="swp_video_btn_scd <?php echo esc_attr( $css_class ); ?>">
		<div class="video_play_btn_scd" data-vsource="<?php echo esc_attr($vsource); ?>" data-vid="<?php echo esc_attr($vid); ?>">
			<i class="fas fa-play video_scd_play_icon" aria-hidden="true"></i>
		</div>
		<span class="swp_after_video_btn"><?php echo esc_html($button_text); ?></span>
	</div>


	<?php	

	$output = ob_get_clean();
	return $output;	
}


/*
	Horizontal Separator
*/
add_shortcode('swp_horizontal_separator', 'SLIDE_SWP_swp_horizontal_separator');
function SLIDE_SWP_swp_horizontal_separator($atts) {
	$defaults = array(
		'sep_width' 	=> '70px',
		'sep_align'		=> 'align_left' /*align_left/align_right/align_center*/
	);
	extract(shortcode_atts($defaults, $atts));

	$sep_width - intval($sep_width);

	ob_start();

	?>

	<div class="swp_horizontal_separator">
		<div class="swp_separator_inner <?php echo esc_attr($sep_align); ?>" data-sepwidth="<?php echo esc_attr($sep_width); ?>"></div>
	</div>

	<?php	

	$output = ob_get_clean();
	return $output;
}

/*
	Single Album - Music
*/

add_shortcode('swp_single_album_scd', 'SLIDE_SWP_swp_single_album_scd');
function SLIDE_SWP_swp_single_album_scd($atts) {
	$defaults = array(
		'album_id' 			=> '',
		'percent_width'		=> '100%', //percent
		'align'				=> "align_left",	//left/right
		'padding_left'			=> '0',
		'padding_right'			=> '0',
		'padding_top'			=> '0',
		'padding_bottom'			=> '0',
		'ignore_pad_on_mob'	=> 'ignore_padding_on_mobile'
	);
	extract(shortcode_atts($defaults, $atts));


	$percent_width = intval($percent_width);
	if (0 == $percent_width) {
		$percent_width = "100";
	}
	$percent_width .= "%";

	$my_album = get_post($album_id);
	if (null == $my_album) {
		return "";
	}

	$img_url = get_the_post_thumbnail_url($album_id, 'full');
	$css_classes= "swp_single_album_scd swp_custom_ar ar_square lc_swp_background_image swp_custom_percentwidth ". $align ;

	/*paddings*/
	$padding_left = intval($padding_left);
	$padding_right = intval($padding_right);
	$padding_top = intval($padding_top);
	$padding_bottom = intval($padding_bottom);
	$data_padding = $padding_top . " " . $padding_right . " " . $padding_bottom . " " . $padding_left;

	ob_start();

	?>
	<div class="swp_single_album_scd_container clearfix swp_custom_padding <?php echo esc_attr($ignore_pad_on_mob); ?>" data-padding="<?php echo esc_attr($data_padding); ?>">
		<a href="<?php echo esc_attr(esc_url(get_permalink($album_id))); ?>">
			<div class="<?php echo esc_attr($css_classes); ?>" data-bgimage="<?php echo esc_attr(esc_url($img_url)); ?>" data-percentwidth="<?php echo esc_attr($percent_width); ?>">
			</div>
		</a>
	</div>

	<?php

	$output = ob_get_clean();
	return $output;
}

/*
	Events
*/
add_shortcode('swp_last_events_scd', 'SLIDE_SWP_swp_last_events_scd');
function SLIDE_SWP_swp_last_events_scd($atts) {
	$defaults = array(
		'eventspageurl' => '',
		'viewallmessage' => 'View All Shows',
		'eventsnumber' => '4',
		'event_category'	=> "0",
		'past_next'	=> 	"next",		/*next/past*/
		'artist_id'	=> "0"
	);
	extract(shortcode_atts($defaults, $atts));

	/*default - next events*/
	$meta_query_event = array(
			'relation' => 'AND',
			'event_date' => array(
			   'key' => 'event_date',
			   'value' => date('Y/m/d',current_time('timestamp')),
			   'compare' => '>='
			),
			'event_time' => array(
			   'key' => 'event_time'
			)			
		);
	$order_events_by = array('event_date' => 'ASC', 'event_time' => 'ASC');

	/*shows past events*/
	if ("past" == $past_next) {
		$meta_query_event = array(
				'relation' => 'AND',
				'event_date' => array(
				   'key' => 'event_date',
				   'value' => date('Y/m/d',current_time('timestamp')),
				   'compare' => '<'
				),
				'event_time' => array(
				   'key' => 'event_time'
				)
			);
		$order_events_by = array('event_date' => 'DESC', 'event_time' => 'DESC');	
	}

	$args = array(
		'numberposts'	=> $eventsnumber,
		'posts_per_page'   => $eventsnumber,
		'offset'           => 0,
		'category'         => '',
		'orderby'          => $order_events_by,
		'order'            => 'ASC',
		'meta_key'         => 'event_date',
		'post_type'        => 'js_events',
		'post_status'      => 'publish',
		'suppress_filters' => false,
		'meta_query' 		=> $meta_query_event
	);

	/*filter by artist*/
	if ("0" != $artist_id) {
		$args['meta_query'][] = array(
				'key' => 'swp_artist_selection',
				'value' => $artist_id,
				'compare' => 'LIKE'
			);
	}

	if (('0' != $event_category) && strlen($event_category)) {
		$args["tax_query"] = array(
								array(
									'taxonomy' => 'event_category',
									'field'    => 'term_id',
									'terms'    => $event_category,
								),
							);
	}

	$wp_query= null;
	$wp_query = new WP_Query();
	$wp_query->query($args);

	ob_start();
	
	if ( $wp_query->have_posts()) {
		?>
		<div class="lc_swp_boxed">
			<ul class="events_list vc_events_element">
				<?php
				while ($wp_query->have_posts()) {
					$wp_query->the_post();

					$post_id = get_the_ID();
					$event_title = get_the_title();
					
					$event_location = get_post_meta( get_the_ID(), 'event_location', true);
					$event_venue = get_post_meta( get_the_ID(), 'event_venue', true);
					$event_time = esc_html(get_post_meta($post_id, 'event_time', true));
					$event_buy_tickets_url = esc_html(get_post_meta($post_id, 'event_buy_tickets_url', true));
					$event_buy_tickets_target = esc_html(get_post_meta($post_id, 'event_buy_tickets_target', true));

					$event_canceled = esc_html(get_post_meta($post_id, 'event_canceled', true));
					$event_canceled = empty($event_canceled) ? false : true;

					$event_sold_out = esc_html(get_post_meta($post_id, 'event_sold_out', true));
					$event_sold_out = empty($event_sold_out) ? false : true;

					$event_buy_tickets_message = esc_html(get_post_meta($post_id, 'event_buy_tickets_message', true));					
					?>

					<li class="single_event_list clearfix">
						<a href="<?php echo get_the_permalink(); ?>">
							<div class="event_list_entry event_date">
								<?php
								$event_date = esc_html(get_post_meta($post_id, 'event_date', true));
								 if ($event_date != "") {
									@$event_date = str_replace("/","-", $event_date);
									@$dateObject = new DateTime($event_date);
								}
												
								$el_day = $dateObject->format('d');
								$el_month = $dateObject->format('M');
								$el_month = SLIDE_SWP_get_translated_month($el_month);
								?>
								<div class="text_center event_list_date_container">
									<div class="eventlist_day"><?php echo esc_html($el_day); ?></div>
									<div class="eventlist_month"><?php echo esc_html($el_month); ?></div>
								</div>
							</div>

							<div class="event_list_entry event_title_img clearfix">
								<?php if (has_post_thumbnail()) { ?>
									<div class="event_img"> 
										<img src="<?php echo esc_url(get_the_post_thumbnail_url('', 'medium')); ?>" alt="<?php echo esc_attr($event_title); ?>">
									</div>
								<?php } ?>
								<div class="evnt_list_title_loc">
									<div class="event_list_title"><?php echo esc_html($event_title); ?></div>
									<div class="event_list_location"> <?php echo esc_html($event_location); ?> </div>
								</div>
							</div>

							<div class="event_list_entry event_venue">
								<i class="fas fa-map-marker-alt" aria-hidden="true"></i>
								<?php echo esc_html($event_venue); ?>
							</div>


							<div class="event_list_entry event_time">
								<i class="far fa-clock" aria-hidden="true"></i>
								<?php echo esc_html($event_time); ?>
							</div>

							<div class="event_list_entry event_buy">
									<?php
									$button_class = "event_buy_btn ";
									$button_text = "";
									$event_ticket_url = $event_buy_tickets_url;
									$ticket_click_target = $event_buy_tickets_target;
									$show_arrow = false;


									if ($event_canceled) {
										$button_class .= "event_canceled";
										$button_text = esc_html__("Canceled", 'slide-music-core');
									} elseif ($event_sold_out) {
										$button_class .= "event_sold_out";
										$button_text = esc_html__("Sold Out", 'slide-music-core');
									} else {
										if (empty($ticket_click_target)) {
											$ticket_click_target = "_blank";
										}

										if (empty($event_buy_tickets_url)) {
											$event_ticket_url = get_the_permalink();
											$ticket_click_target = "_self";
										}

										$button_class .= "lc_js_link";
										$button_text = $event_buy_tickets_message;
									}
									?>

									<?php if (!empty($event_buy_tickets_message)) { ?>
										<div class="<?php echo esc_attr($button_class); ?>" data-href="<?php echo esc_url($event_ticket_url); ?>" data-target="<?php echo esc_attr($ticket_click_target); ?>">

											<?php echo esc_html($button_text); ?>
											<?php if ($show_arrow) { ?>
											<i class="fas fa-arrow-right" aria-hidden="true"></i>
											<?php } ?>
										</div>
									<?php } ?>
							</div>
						</a>
					</li>
				<?php	
				} /*while*/
				wp_reset_postdata();
				?>
			</ul>
			
			<?php
			if (!empty($eventspageurl)) {
			?>	
				<div class="swp_slide_link vc_events_more lc_swp_boxed text_center show_arrow">
					<a href="<?php echo esc_url($eventspageurl); ?>" class="vibrant_color">
						<?php echo esc_html($viewallmessage); ?>
						<i class="fas fa-arrow-right" aria-hidden="true"></i>						
					</a>
				</div>
			<?php	
			}
			?>
		</div>
		<?php
	}
	/* Reset main query loop */
	wp_reset_query ();
	wp_reset_postdata ();	
	
	$output = ob_get_clean();
	return $output;
}

/*
	Events (Cards)
*/
add_shortcode('swp_last_events_cards_scd', 'SLIDE_SWP_swp_last_events_cards_scd');
function SLIDE_SWP_swp_last_events_cards_scd($atts) {
	$defaults = array(
		'eventsnumber' => '4',
		'event_category'	=> "0",
		'past_next'	=> 	"next",		/*next/past*/
		'artist_id'	=> "0"
	);
	extract(shortcode_atts($defaults, $atts));

	/*default - next events*/
	$meta_query_event = array(
			'relation' => 'AND',
			'event_date' => array(
			   'key' => 'event_date',
			   'value' => date('Y/m/d',current_time('timestamp')),
			   'compare' => '>='
			),
			'event_time' => array(
			   'key' => 'event_time'
			)			
		);
	$order_events_by = array('event_date' => 'ASC', 'event_time' => 'ASC');

	/*shows past events*/
	if ("past" == $past_next) {
		$meta_query_event = array(
				'relation' => 'AND',
				'event_date' => array(
				   'key' => 'event_date',
				   'value' => date('Y/m/d',current_time('timestamp')),
				   'compare' => '<'
				),
				'event_time' => array(
				   'key' => 'event_time'
				)
			);
		$order_events_by = array('event_date' => 'DESC', 'event_time' => 'DESC');	
	}

	$args = array(
		'numberposts'	=> $eventsnumber,
		'posts_per_page'   => $eventsnumber,
		'offset'           => 0,
		'category'         => '',
		'orderby'          => $order_events_by,
		'order'            => 'ASC',
		'meta_key'         => 'event_date',
		'post_type'        => 'js_events',
		'post_status'      => 'publish',
		'suppress_filters' => false,
		'meta_query' 		=> $meta_query_event
	);

	/*filter by artist*/
	if ("0" != $artist_id) {
		$args['meta_query'][] = array(
				'key' => 'swp_artist_selection',
				'value' => $artist_id,
				'compare' => 'LIKE'
			);
	}

	if (('0' != $event_category) && strlen($event_category)) {
		$args["tax_query"] = array(
								array(
									'taxonomy' => 'event_category',
									'field'    => 'term_id',
									'terms'    => $event_category,
								),
							);
	}

	$wp_query= null;
	$wp_query = new WP_Query();
	$wp_query->query($args);

	ob_start();

	if ($wp_query->have_posts()) { ?>
		<div class="lc_swp_boxed swp_event_cards_container clearfix">
			<?php while ($wp_query->have_posts()) {
				$wp_query->the_post();
				$post_id = get_the_ID();

				$event_title = get_the_title();
				$event_venue = get_post_meta(get_the_ID(), 'event_venue', true);
				$event_buy_tickets_message = esc_html(get_post_meta($post_id, 'event_buy_tickets_message', true));
				$event_buy_tickets_url = esc_html(get_post_meta($post_id, 'event_buy_tickets_url', true));
				$event_buy_tickets_target = esc_html(get_post_meta($post_id, 'event_buy_tickets_target', true));

				$event_canceled = esc_html(get_post_meta($post_id, 'event_canceled', true));
				$event_canceled = empty($event_canceled) ? false : true;				

				$event_sold_out = esc_html(get_post_meta($post_id, 'event_sold_out', true));
				$event_sold_out = empty($event_sold_out) ? false : true;
				$post_thumbnail = has_post_thumbnail() ? get_the_post_thumbnail_url('', 'full') : "";

				$event_date = esc_html(get_post_meta($post_id, 'event_date', true));
				 if ($event_date != "") {
					@$event_date = str_replace("/","-", $event_date);
					@$dateObject = new DateTime($event_date);
				}
								
				$el_day = $dateObject->format('d');
				$el_month = $dateObject->format('M');
				$el_month = SLIDE_SWP_get_translated_month($el_month);				
				?>

				<div class="swp_event_card lc_swp_background_image swp_custom_ar ar_1910" data-bgimage="<?php echo esc_attr($post_thumbnail); ?>">
					<div class="swp_event_card_inner">
						<div class="event_card_overlay transition2"></div>
						<div class="event_card_datails clearfix transition3">
							<div class="event_card_detail event_card_date">
								<div class="event_card_day"> <?php echo esc_html($el_day); ?> </div>
								<div class="event_card_month"> <?php echo esc_html($el_month); ?> </div>
							</div>
							<div class="event_card_detail event_card_name_venue">
								<div class="event_card_name">
									<a href="<?php echo get_the_permalink(); ?>" class="event_card_name_link">
										<?php echo esc_html($event_title); ?>
									</a>
								</div>
								<div class="event_card_venue"><?php echo esc_html($event_venue); ?></div>
							</div>
						</div>

						<div class="event_card_buy transition3">
							<?php if ($event_sold_out) {
								echo esc_html__("Sold Out", 'slide-music-core');
							} elseif ($event_canceled) { 
								echo esc_html__("Canceled", 'slide-music-core');
							} else { ?>
								<a href="<?php echo esc_attr(esc_url($event_buy_tickets_url)); ?>" target="<?php echo esc_attr($event_buy_tickets_target); ?>">
									<?php echo $event_buy_tickets_message; ?>
								</a>
							<?php }?>
						</div>
					</div>
				</div>

			<?php } ?>
		</div>
	<?php }

	$output = ob_get_clean();
	return $output;
}

/*
	Latest Artists
*/
add_shortcode('swp_latest_artists_scd', 'SLIDE_SWP_swp_latest_artists_scd');
function SLIDE_SWP_swp_latest_artists_scd($atts) {
	$defaults = array(
		'artistsnumber' => '4',
		'artist_category'	=> "0"
	);
	extract(shortcode_atts($defaults, $atts));

	$args = array(
		'numberposts'		=> $artistsnumber,
		'posts_per_page'   => $artistsnumber,
		'offset'           => 0,
		'category'         => '',
		'orderby'          => 'post_date',
		'order'            => 'DESC',
		'include'          => '',
		'exclude'          => '',
		'meta_key'         => '',
		'meta_value'       => '',
		'post_type'        => 'js_artist',
		'post_mime_type'   => '',
		'post_parent'      => '',
		'post_status'      => 'publish',
		'suppress_filters' => false
	);	

	/*filter the artist category*/
	if (('0' != $artist_category) && strlen($artist_category)) {
		$args["tax_query"] = array(
								array(
									'taxonomy' => 'artist_category',
									'field'    => 'term_id',
									'terms'    => $artist_category,
								),
							);
	}
	
	$wp_query= null;
	$wp_query = new WP_Query();
	$wp_query->query($args);


	/*initial layout settings*/
	$archive_nav_classes = "blog_standard_nav discography_post_nav";
	$container_class = 'lc_content_full lc_basic_content_padding';
	$items_on_row = 4; /*to be extended*/
	$item_count = 0;

	if (4 == $items_on_row) {
		$container_class .= " lc_swp_boxed";
		$archive_nav_classes .= " lc_swp_boxed";
	} else {
		$container_class .= " lc_swp_full";
		$archive_nav_classes .= " lc_swp_full";
	}	

	ob_start();

	if ($wp_query->have_posts()) {
	?>	
		<div class="<?php echo esc_attr($container_class); ?>">
			<div class="albums_container artists_container clearfix">
				<?php
				while ($wp_query->have_posts()) : $wp_query->the_post();
					$item_count++;
					$artist_id = get_the_ID();

					$has_right_padding = (0 == $item_count % $items_on_row) ? '' : ' has_right_padding';
					$bg_img_url = "";
					if (has_post_thumbnail()) {
						$bg_img_url = get_the_post_thumbnail_url('', 'full');
					}

					$custom_css_class = ' artists_' . $items_on_row . "_on_row";
					$artist_nickname = esc_html(get_post_meta($artist_id, 'artist_nickname', true));

					/*social options*/
					$available_profiles = array(
						/*'icon name fab-[icon name]'	=> 'settings name'*/
						'facebook-f'		=> 'artist_facebook',
						'twitter'			=>'artist_twitter',		
						'instagram'			=> 'artist_instagram',
						'soundcloud'		=>'artist_soundcloud',	
						'youtube'			=>'artist_youtube'
					);
					$artist_profiles = array();
					foreach ($available_profiles as $key =>	$profile) {
						$profile_url = esc_url(get_post_meta($artist_id, $profile, true));

						if (!empty($profile_url)) {
							$single_profile = array();
							$single_profile['url'] 	= $profile_url;
							$single_profile['icon'] 	= $key;

							$artist_profiles[] = $single_profile;
						}
					}
					?>

					<div class="single_artist_item <?php echo esc_attr($has_right_padding).esc_attr($custom_css_class); ?>">
							<div class="artist_img_container lc_swp_background_image" data-bgimage="<?php echo esc_url($bg_img_url); ?>">
								<div class="album_overlay artist_overlay lc_swp_overlay transition3 lc_js_link" data-href="<?php the_permalink(); ?>" data-target="_self"></div>
								<div class="artist_item_socials">
									<?php foreach ($artist_profiles as $social_profile) { ?>
										<div class="artist_social_profile">
											<a href="<?php echo esc_url($social_profile['url']); ?>" target="_blank" class="artist_social_link">
												<i class="fab fa-<?php echo esc_attr($social_profile['icon']); ?>"></i>
											</a>
										</div>
									<?php } ?>		
								</div>
							</div>
							<a href="<?php the_permalink();?>">
								<h3 class="artist_title album_heading transition4"> <?php the_title(); ?> </h3>
							</a>
							<div class="artist_nickname"> <?php echo esc_html($artist_nickname); ?> </div>
					</div>					

					<?php
				endwhile;
				wp_reset_postdata();
				?>
			</div>
		</div>
	<?php
	}

	$output = ob_get_clean();
	return $output;
}

/*
	User Review Container
*/
add_shortcode('swp_review_container_scd', 'SLIDE_SWP_swp_review_container_scd');
function SLIDE_SWP_swp_review_container_scd($atts, $content = "") {
	$defaults = array(
		'slide_speed' 		=> '400',	/*400 - 1000*/
		'slide_delay'		=> '4000'	/*1000 - 10000*/
	);
	extract(shortcode_atts($defaults, $atts));

	$slide_speed = intval($slide_speed);
	$slide_speed = $slide_speed < 400 ? 400 : $slide_speed;
	$slide_speed = $slide_speed > 1000 ? 1000 : $slide_speed;

	$slide_delay = intval($slide_delay);
	$slide_delay = $slide_delay < 1000 ? 1000 : $slide_delay;
	$slide_delay = $slide_delay > 10000 ? 10000 : $slide_delay;	

	ob_start();
?>
	<div class="lc_swp_boxed lc_reviews_slider_container" data-slidespeed="<?php echo esc_attr($slide_speed); ?>" data-slidedelay="<?php echo esc_attr($slide_delay); ?>">
		<i class="fas fa-quote-left swp_before_reviews" aria-hidden="true"></i>

		<div class="lc_reviews_slider">
			<ul>
			<?php echo do_shortcode($content); ?>
			</ul>
		</div>	
	</div>
<?php	
	$output = ob_get_clean();
	return $output;
}

/*
	Single User Review
*/
add_shortcode('swp_user_review_scd', 'SLIDE_SWP_swp_user_review_scd');
function SLIDE_SWP_swp_user_review_scd($atts) {
	$defaults = array(
		'reviewer_name' 		=> 'Martin Stanley',
		'reviewer_position' 	=> 'Manager',	/*ex. Spotify Manager*/
		'reviewer_image'		=> '',
		'review_content' 		=> 'We just want to say thank you...'
	);
	extract(shortcode_atts($defaults, $atts));
	
	ob_start();
?>

	<li>
		<div class="lc_swp_boxed text_center">
			<div class="lc_review_content">
				<?php echo esc_html($review_content); ?>
			</div>

			<h5 class="lc_reviewer_name"><?php echo esc_html($reviewer_name); ?></h5>
			<?php if (strlen($reviewer_position)) { ?>
				<div class="lc_reviewer_position">
					<?php echo esc_html($reviewer_position); ?>
				</div>
			<?php } ?>

			<div class="lc_reviewer_image">
				<?php 
				if ("" != $reviewer_image) {
					echo wp_get_attachment_image($reviewer_image, "full");
				}
				?>
			</div>
			

		</div>
	</li>

<?php	
	$output = ob_get_clean();
	return $output;
}

/*
	Blog Post
*/
add_shortcode('swp_blog_scd', 'SLIDE_SWP_swp_blog_scd');
function SLIDE_SWP_swp_blog_scd($atts) {
	$defaults = array(
		'postsnumber' 		=> '3',
		'post_category'		=> 'all',
		'user_excerpt_length'	=> '17',
		'show_post_thumbnails'	=> 'show_thumbnails'	/*show_thumbnails/hide_thumbnails*/
	);
	extract(shortcode_atts($defaults, $atts));


	if ('all' == $post_category) {
		$post_category = '';
	}

	$args = array(
		'numberposts'	=> $postsnumber,
		'posts_per_page'   => $postsnumber,
		'orderby'          => 'post_date',
		'order'            => 'DESC',
		'post_type'        => 'post',
		'post_status'      => 'publish',
		'cat'				=> $post_category,
		'suppress_filters' => false
	); 	
	$wp_query= null;
	$wp_query = new WP_Query();
	$wp_query->query($args);

	$show_post_thumbnails = "show_thumbnails" == $show_post_thumbnails ? true : false;
	$center_css_class = "text_left";
	$container_class = 'lc_blog_masonry_container blog_container lc_swp_boxed swp_blog_scd_container';
	$gap_width = 60;
	$bricks_on_row = 3;	

	ob_start();
	if ($wp_query->have_posts()) { ?>

		<div class="<?php echo esc_attr($container_class); ?>" data-gapwidth="<?php echo esc_attr($gap_width); ?>" data-bricksonrow="<?php echo esc_attr($bricks_on_row); ?>">
			<?php
			while ($wp_query->have_posts()) : $wp_query->the_post();

				$thumbnail_class	= has_post_thumbnail() ? 'has_thumbnail' : 'no_thumbnail';
				$post_classes 		= 'post_item lc_blog_masonry_brick ' . $thumbnail_class;
				$masonry_excerpt_length = $user_excerpt_length;

				?>
				<article <?php post_class($post_classes);?>>
					<?php if ($show_post_thumbnails && has_post_thumbnail()) { ?>
						<a href="<?php the_permalink(); ?>">
							<?php the_post_thumbnail('full', array('class' => 'lc_masonry_thumbnail_image')); ?>
						</a>
					<?php } ?>

					<div class="post_item_details <?php echo esc_attr($thumbnail_class) ?>">
						<div class="post_item_meta lc_post_meta masonry_post_meta lc_vibrant_color">
							<?php echo get_the_date(get_option('date_format')); ?>
						</div>

						<a href="<?php the_permalink(); ?>">
							<h2 class="lc_post_title transition4 masonry_post_title">
								<?php the_title(); ?>
							</h2>
						</a>

						<div class="lc_post_excerpt masonry_excerpt">
							<?php
								$default_excerpt = get_the_excerpt();
								echo "<p>".wp_trim_words($default_excerpt, $masonry_excerpt_length)."</p>";
							?>
						</div>

						<div class="masonry_read_more swp_slide_link">
							<a href="<?php the_permalink(); ?>" class="masonry_read_more">
								<?php echo esc_html__("Read more", 'slide'); ?>
								<span class="swp_before_right_arrow transition4"></span><span class="swp_arrow swp_arrow_right"></span>
							</a>
						</div>
					</div>
				</article>
				<?php

			endwhile;
			?>
		</div>

	<?php } ?>

	<?php	
	$output = ob_get_clean();
	return $output;
}

add_shortcode('swp_mailchimp_subscribe', 'SLIDE_SWP_swp_mailchimp_subscribe_scd');
function SLIDE_SWP_swp_mailchimp_subscribe_scd($atts) {
	$defaults = array(
		'button_text' 			=> 'Subscribe',
		'input_placeholder'		=> 'Email Address',
		'bg_color'				=> 'rgba(9, 9, 47, 0.7)',
		'width'					=> 'default', /*default/custom*/
		'user_px_width'			=> '',
		'align'					=> 'left'	/*left/center*/
	);
	extract(shortcode_atts($defaults, $atts));

	$btn_loading_val = esc_html__('Processing...', 'slide-music-core');

	$elt_class = "swp_mc_subscr_container";
	if ("custom" == $width) {
		$user_px_width = intval($user_px_width);
		if ($user_px_width > 0) {
			$elt_class .= " user_cust_width";
		}
		if ("center" == $align) {
			$elt_class .= " align_center";
		}
	}
	ob_start();
?>
	<div class="<?php echo esc_attr($elt_class); ?>" data-width="<?php echo esc_attr($user_px_width); ?>">
		<div class="swp_mc_subscr_form_container clearfix lc_swp_bg_color" data-color="<?php echo esc_attr($bg_color); ?>">
			<form class="swp_mc_subscr_form clearfix">
				<i class="far fa-envelope before_at_cf_detail" aria-hidden="true"></i>
				<input type="text" placeholder="<?php echo esc_attr($input_placeholder); ?>" name="newsletter_email" class="mc_email at_newslet_entry at_news_input_entry required"/>

				<input name="newsletter_subscribe" type="submit" data-btnval="<?php echo esc_attr($button_text);  ?>" data-loadingmsg="<?php echo esc_attr($btn_loading_val); ?>" class="at_newslet_entry at_news_button_entry" value="<?php echo esc_attr($button_text); ?>" >
				<input type="hidden" name="action" value="swpmcform_action" />
				<?php wp_nonce_field('swpmcform_action', 'subscrform_nonce');?>			
			</form>
		</div>
		<div class="swp_mc_form_success">
			<?php echo esc_html__('Thank You For Subscribing! You have been added to our mailing list.', 'slide-music-core'); ?>
		</div>
		<div class="swp_mc_form_error">
		</div>		
	</div>
<?php
	$output = ob_get_clean();

	return $output;	
}

add_shortcode('swp_slide_player', 'SLIDE_SWP_swp_slide_player_scd');
function SLIDE_SWP_swp_slide_player_scd($atts,  $content = "") {
	$defaults = array(
		'album_cover_img' 		=> '',
		'playlist_bg_img'		=> '',
		'album_title'			=> 'Last Man Standing',
		'featured_text'			=> 'Featured Album',
		'hover_color'			=> '#0a0a30',
		'autoplay'			=>	'no',/*yes_no*/
		'album_buy_text'	=>	'Buy On Itunes',
		'album_buy_url'		=>	'',
		'button_buy_icon'	=>  'apple', /*none, amazon, spotify, apple, google-play*/
		'overlap_prev'		=>  ''	/*overlap_prev/no_overlap*/
	);
	extract(shortcode_atts($defaults, $atts));

	$elt_classes = "swp_music_player lc_swp_boxed clearfix " . $overlap_prev;

	ob_start();
?>

	<div class="<?php echo esc_attr($elt_classes); ?>" data-entryhbgcolor="<?php echo esc_attr($hover_color); ?>" data-autoplay="<?php echo esc_attr($autoplay); ?>">
		<div class="music_player_left lc_swp_background_image" data-bgimage="<?php echo wp_get_attachment_image_url($album_cover_img, "full"); ?>">
		</div>

		<div class="music_player_right lc_swp_background_image" data-bgimage="<?php echo wp_get_attachment_image_url($playlist_bg_img, "full"); ?>">
			<div class="swp_player_top">
				<div class="player_top_content">
					<?php if (strlen($featured_text)) { ?>
						<div class="album_featured_text">
							<?php echo esc_html($featured_text); ?>
						</div>
					<?php } ?>

					<div class="swp_player_title">
						<?php echo esc_html($album_title);?>
					</div>
				</div>

				<?php if (strlen($album_buy_url)) { ?>
				<div class="swp_player_button_container">
					<a class="lc_button lc_button_fill swp_player_button clearfix" href="<?php echo esc_url($album_buy_url); ?>" target="_blank">
						<?php if("none" != $button_buy_icon) { ?>
							<i class="fab fa-<?php echo esc_attr($button_buy_icon); ?>"></i>
						<?php }

						echo esc_html($album_buy_text); 
						?>
					</a>
				</div>
				<?php } ?>
			</div>

			<div class="swp_player_content">
				<?php echo do_shortcode($content); ?>
			</div>	

			<div class="swp_player_bottom">
				<div class="swp_player_bottom_inner">
					<div class="player_time_slider_base"></div>
					<div class="player_time_slider"></div>
					<div class="swp_current_play">
						<div class="before_current_song_name"><?php echo esc_html__("Playing", "slide-music-core"); ?></div>
						<div class="current_song_name"></div>
					</div>

					<div class="swp_player_controls">
						<i class="fas fa-step-backward"></i>
						<i class="fas fa-play player_play"></i>
						<i class="fas fa-pause display_none"></i>
						<i class="fas fa-step-forward"></i>
					</div>

					<div class="swp_timeline">
						<span class="song_current_progress"></span>
						<span class="player_duration_sep">&#47;</span>
						<span class="song_duration"></span>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php	

	$output = ob_get_clean();
	return $output;
}


add_shortcode('swp_music_player_entry', 'SLIDE_SWP_swp_music_player_entry_scd');
function SLIDE_SWP_swp_music_player_entry_scd($atts) {
	$defaults = array(
		'song_name' 		=> '',
		'amazon_buy_url'	=> '',	/*amazon, spotify, apple, google-play*/
		'spotify_buy_url'	=> '',
		'apple_buy_url'		=> '',
		'gplay_buy_url'		=> '',
		'youtube_url'		=> '',
		'soundcloud_url'			=> '',
		'media_file_id'		=> ''
	);
	
	extract(shortcode_atts($defaults, $atts));

	$media_file = wp_get_attachment_url($media_file_id);
	if (!$media_file) {
		$media_file = "";
	}
	
	ob_start();
?>
	
	<div class="swp_music_player_entry clearfix" data-mediafile="<?php echo esc_attr($media_file); ?>">
		<span class="swp_song_details player_entry_left">
			<span class="play_icon">
				<i class="fas fa-play before_song"></i>
			</span>
			<span class="player_song_name transition3">
				<?php echo esc_html($song_name); ?>
			</span>
		</span>

		<span class="entry_duration"></span>		

		<span class="song_buy_icons transition3">
			<?php if (strlen($amazon_buy_url)) { ?>
				<a target="_blank" class="buy_song_icon" href="<?php echo esc_url($amazon_buy_url); ?>">
					<i class="fab fa-amazon"></i>
				</a>
			<?php } ?>
			<?php if (strlen($spotify_buy_url)) { ?>
				<a target="_blank" class="buy_song_icon" href="<?php echo esc_url($spotify_buy_url); ?>">
					<i class="fab fa-spotify"></i>
				</a>
			<?php } ?>
			<?php if (strlen($apple_buy_url)) { ?>
				<a target="_blank" class="buy_song_icon" href="<?php echo esc_url($apple_buy_url); ?>">
					<i class="fab fa-apple"></i>
				</a>
			<?php } ?>
			<?php if (strlen($gplay_buy_url)) { ?>
				<a target="_blank" class="buy_song_icon" href="<?php echo esc_url($gplay_buy_url); ?>">
					<i class="fab fa-google-play"></i>
				</a>
			<?php } ?>
			<?php if (strlen($youtube_url)) { ?>
				<a target="_blank" class="buy_song_icon" href="<?php echo esc_url($youtube_url); ?>">
					<i class="fab fa-youtube"></i>
				</a>
			<?php } ?>
			<?php if (strlen($soundcloud_url)) { ?>
				<a target="_blank" class="buy_song_icon" href="<?php echo esc_url($soundcloud_url); ?>">
					<i class="fab fa-soundcloud"></i>
				</a>
			<?php } ?>
		</span>
	</div>

<?php	
	$output = ob_get_clean();
	return $output;
}

add_shortcode('swp_gallery_scd', 'SLIDE_SWP_swp_gallery_scd');
function SLIDE_SWP_swp_gallery_scd($atts) {
	$defaults = array(
	  'rowheight' => '180',
	  'images' => ''
	);
	extract(shortcode_atts($defaults, $atts));

	if ('' == $images) {
		return "";
	}
	
	if (empty($rowheight) || !is_numeric($rowheight)) {
		$rowheight = 180;
	}

	ob_start();
?>

	<div class="lc_swp_justified_gallery" data-rheight="<?php echo esc_attr($rowheight); ?>">
		<?php
		$photoAlbumUnique = "photoAlbum".rand();
		$images = explode(',', $images);
		foreach($images as $imageId) { ?>
			<div class="img_box">
				
				<a href="<?php echo esc_attr(wp_get_attachment_url($imageId)); ?>" data-lightbox="<?php echo esc_attr($photoAlbumUnique); ?>">
					<?php echo wp_get_attachment_image($imageId, 'full'); ?>
					<div class="gallery_brick_overlay gallery_scd_overlay"></div>
				</a>
			</div>
		<?php } ?>
	</div>
	
<?php
	$output = ob_get_clean();
	return $output;
}

add_shortcode('swp_contact_form_scd', 'SLIDE_SWP_swp_contact_form_scd');
function SLIDE_SWP_swp_contact_form_scd($atts) {
	$defaults = array(
		'input_styling' => '',
		'button_style'	=> ''/*btn_square, btn_rounded*/
	);

	extract(shortcode_atts($defaults, $atts));
	
	$additional_input_class = "two_on_row" == $input_styling ? " two_on_row two_on_row_layout" : "";

	ob_start();
?>

<div class="swp_contactform<?php echo esc_attr($additional_input_class); ?>">
	<form class="swp_contactform<?php echo esc_attr($additional_input_class); ?>">
		<ul class="contactform_fields">

			<li class="comment-form-author swp_cf_entry<?php echo esc_attr($additional_input_class); ?>">
				<input type="text" placeholder="<?php echo esc_html__('Your Name ', 'slide'); ?>" name="contactName" id="contactName" class="lucille_cf_input required requiredField contactNameInput" />
				<i class="far fa-user swp_cf_icon"></i>
				<div class="swp_cf_error"><?php echo esc_html__('Please enter your name', 'slide'); ?></div>
			</li>

			<li class="comment-form-email swp_cf_entry<?php echo esc_attr($additional_input_class); ?>">
				<input type="text" placeholder="<?php echo esc_html__('Your Email ', 'slide'); ?>" name="email" id="contactemail" class="lucille_cf_input required requiredField email" />
				<i class="far fa-envelope swp_cf_icon" aria-hidden="true"></i>
				<div class="swp_cf_error"><?php echo esc_html__('Please enter a correct email address', 'slide'); ?></div>
			</li>

			<li class="comment-form-comment swp_cf_entry">
				<textarea name="comments" placeholder="<?php echo esc_html__('Your Message ', 'slide'); ?>" id="commentsText" rows="6" cols="30" class="lucille_cf_input required requiredField contactMessageInput"></textarea>
				<div class="swp_cf_error"><?php echo esc_html__('Please enter a message', 'slide'); ?></div>
			</li>

			<li class="wp_mail_error">
				<div class="swp_cf_error"><?php echo esc_html__('Cannot send mail, an error occurred while delivering this message. Please try again later.', 'slide'); ?></div>
			</li>

			<li class="form_result_error"></li>	

			<li class="formResultOK">
				<div class="swp_cf_error"><?php echo esc_html__('Your message was sent successfully. Thanks!', 'slide'); ?></div>
			</li>
			<li class="contact_buttom">
				<input name="Button1" type="submit" id="submit" class="lc_button contact_button <?php echo esc_attr($button_style); ?>" data-loadingmsg="<?php echo esc_html__("Loading...", 'slide'); ?>" value="<?php echo esc_html__('Send Email', 'slide'); ?>" >
			</li>

		</ul>
		<input type="hidden" name="action" value="swpcontactform_action" />
		<?php wp_nonce_field('swpcontactform_action', 'contactform_nonce');?>
	</form>
</div>
	
	<?php
	$output = ob_get_clean(); 

	return $output;
}

add_shortcode('swp_contact_details_scd', 'SLIDE_SWP_swp_contact_details_scd');
function SLIDE_SWP_swp_contact_details_scd($atts) {
	$defaults = array();
	extract(shortcode_atts($defaults, $atts));	

	$contact_address = $contact_email = $contact_phone = $contact_phone2 = $contact_fax = "";
	if (function_exists("SLIDE_SWP_get_contact_address")) {
		$contact_address = SLIDE_SWP_get_contact_address();	
	}
	if (function_exists("SLIDE_SWP_get_contact_email")) {
		$contact_email = SLIDE_SWP_get_contact_email();
	}
	if (function_exists("SLIDE_SWP_get_contact_phone")) {
		$contact_phone = SLIDE_SWP_get_contact_phone();
	}
	if (function_exists("SLIDE_SWP_get_2nd_contact_phone")) {
		$contact_phone2 = SLIDE_SWP_get_2nd_contact_phone();
	}
	if (function_exists("SLIDE_SWP_get_contact_fax")) {
		$contact_fax = SLIDE_SWP_get_contact_fax();
	}

	ob_start();
	?>

	<div class="swp_contact_data">
		<?php if (!empty($contact_address)) { ?>
		<div class="contact_address_entry address_entry vibrant_color">
			<?php echo esc_html($contact_address); ?>
		</div>
		<?php }?>

		<?php if (!empty($contact_email)) { ?>
		<div class="contact_address_entry">
			<div class="before_contact_entry">
				<?php echo esc_html__("Email:", 'slide'); ?>
			</div>
			<div class="contact_address_data">
				<?php echo esc_html(sanitize_email($contact_email)); ?>
			</div>
		</div>
		<?php } ?>

		<?php if (!empty($contact_phone)) { ?>
		<div class="contact_address_entry">
			<div class="before_contact_entry">
				<?php echo esc_html__("Phone:", 'slide'); ?>
			</div>
			<div class="contact_address_data">
				<?php echo esc_html($contact_phone); ?>
				<?php if (!empty($contact_phone)) { ?>
					<br> <?php echo esc_html($contact_phone2); ?>
				<?php } ?>
			</div>
		</div>
		<?php } ?>

		<?php if (!empty($contact_fax)) { ?>
		<div class="contact_address_entry">
			<div class="before_contact_entry">
				<?php echo esc_html__("Fax:", 'slide'); ?>
			</div>
			<div class="contact_address_data">
				<?php echo esc_html($contact_fax); ?>
			</div>
		</div>
		<?php } ?>		
	</div>

	<?php
	$output = ob_get_clean(); 

	return $output;
}

add_shortcode('swp_social_profiles_icons_scd', 'SLIDE_SWP_social_profiles_icons_scd');
function SLIDE_SWP_social_profiles_icons_scd($atts) {
	$defaults = array(
		'center_icons' => 'text_center' /*text_center/text_right/text_left*/
	);
	extract(shortcode_atts($defaults, $atts));	
	

	$user_profiles = array();
	if (function_exists('SLIDE_SWP_get_available_social_profiles')) {
		$user_profiles = SLIDE_SWP_get_available_social_profiles();
	}

	ob_start();
	?> 

	<div class="swp_social_profiles_scd <?php echo esc_attr($center_icons); ?>">
		<?php foreach ($user_profiles as $social_profile) { ?>
			<div class="swp_social_profile">
				<a href="<?php echo esc_url($social_profile['url']); ?>" target="_blank">
					<i class="fab fa-<?php echo esc_attr($social_profile['icon']); ?>"></i>
				</a>
			</div>
		<?php } ?>
	</div> 

	<?php
	$output = ob_get_clean();
	
	return $output;
}