<?php
if (shortcode_exists('swp_row_heading')) {
	add_action('vc_before_init', 'SLIDE_SWP_swp_row_heading_map');
	function SLIDE_SWP_swp_row_heading_map() {
			vc_map(array(
				  "name" => esc_html__("Section Heading", "slide-music-core"),
				  "base" => "swp_row_heading",
				  "class" => "",
				  "icon" => CDIR_URL . "visual_composer/vc_icons/vc_heading.png",
				  "category" => esc_html__("Slide Elements", "slide-music-core"),
				  "params" => array(
					array(
						"type" => "textarea_raw_html",
						"class" => "",
						"heading" => esc_html__("Title", "slide-music-core"),
						"param_name" => "title",
						"value" => "U2VjdGlvbiBUaXRsZQ==",
						"description" => esc_html__("Section Heading Text - HTML allowed: &lt;span class=&quot;vibrant_color&quot;&gt;some colored text&lt;/span&gt; to color one or more words in vibrant color.", "slide-music-core")
					),
					array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__("Text align", "slide-music-core"),
						"param_name" => "text_align",
						"value" => array(
							"Center"	=> "text_center",
							"Left"		=> "text_left",
							"Rigth"		=> "text_right"
						),
						"description" => esc_html__("Choose how to center the heading", "slide-music-core")
					),
					array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__("Font Weight", "slide-music-core"),
						"param_name" => "font_weight",
						"value" => array(
							"Black"	=> "fw_900",
							"Bold"		=> "fw_700"
						),
						"description" => esc_html__("Choose the font weight", "slide-music-core")
					),
					array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__("Font Size Preset", "slide-music-core"),
						"param_name" => "font_preset",
						"value" => array(
							"Big"	=> "big_size",
							"Medium"		=> "medium_size"
						),
						"description" => esc_html__("Choose the font size preset", "slide-music-core")
					)	
				 )
			));		
	}
}

if (shortcode_exists('swp_col_heading')) {
	add_action('vc_before_init', 'SLIDE_SWP_swp_col_heading_map');
	function SLIDE_SWP_swp_col_heading_map() {
			vc_map(array(
				  "name" => esc_html__("Column Heading", "slide-music-core"),
				  "base" => "swp_col_heading",
				  "class" => "",
				  "icon" => CDIR_URL . "visual_composer/vc_icons/vc_heading.png",
				  "category" => esc_html__("Slide Elements", "slide-music-core"),
				  "params" => array(
					array(
						"type" => "textarea_raw_html",
						"class" => "",
						"heading" => esc_html__("Title", "slide-music-core"),
						"param_name" => "title",
						"value" => "U2VuZCBNZSBBIE1lc3NhZ2U=",
						"description" => esc_html__("Section Heading Text - HTML allowed: &lt;span class=&quot;vibrant_color&quot;&gt;some colored text&lt;/span&gt; to color one or more words in vibrant color.", "slide-music-core")
					),
					array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__("Text align", "slide-music-core"),
						"param_name" => "text_align",
						"value" => array(
							"Left"	=> "text_left",
							"Center"		=> "text_center",
							"Rigth"		=> "text_right"
						),
						"description" => esc_html__("Choose how to center the heading", "slide-music-core")
					)
				 )
			));		
	}
}

if (shortcode_exists('swp_row_subtitle')) {
	add_action('vc_before_init', 'SLIDE_SWP_swp_row_subtitle_map');
	function SLIDE_SWP_swp_row_subtitle_map() {
		vc_map(array(
			  "name" => esc_html__("Section Subtitle", "slide-music-core"),
			  "base" => "swp_row_subtitle",
			  "class" => "",
			  "icon" => CDIR_URL . "visual_composer/vc_icons/vc_heading.png",
			  "front_enqueue_js" => CDIR_URL . "visual_composer/js/front_enqueue/swp_row_subtitle.js",
			  "category" => esc_html__("Slide Elements", "slide-music-core"),
			  "params" => array(
				array(
					"type" => "textarea",
					"class" => "",
					"heading" => esc_html__("Content", "slide-music-core"),
					"param_name" => "text_content",
					"value" => "Follow our amazing shows",
					"description" => esc_html__("The content of your subtitle.", "slide-music-core")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_html__("Text align", "slide-music-core"),
					"param_name" => "align",
					"value" => array(
						"Center"		=> "text_center",
						"Left"	=> "text_left",
						"Rigth"		=> "text_right"
					),
					"description" => esc_html__("Choose how to center the subtitle", "slide-music-core")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_html__("Text color", "slide-music-core"),
					"param_name" => "text_color",
					"value" => array(
						"Default"		=> "color_default",
						"Vibrant"	=> "color_vibrant",
						"Custom"	=> "color_custom"
					),
					"description" => esc_html__("Choose the text color", "slide-music-core")
				),
				array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => esc_html__("Custom Text Color", "slide-music-core"),
					"param_name" => "user_color",
					"value" => "#ffffff",
					'dependency' => array(
							'element' => 'text_color',
							'value'   => 'color_custom'
						)
				),				
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_html__("Bottom Margin", "slide-music-core"),
					"param_name" => "bottom_margin",
					"value" => array(
						"Add Default Margin"		=> "default_margin",
						"Remove Default Margin"	=> "no_margin"
					),
					"description" => esc_html__("Choose to add or remove the default botton margin of 35px", "slide-music-core")
				)
			 )
		));		
	}
}

if (shortcode_exists('swp_slide_link')) {
	add_action('vc_before_init', 'SLIDE_SWP_swp_slide_link_map');
	function SLIDE_SWP_swp_slide_link_map() {
			vc_map(array(
				  "name" => esc_html__("Slide Link", "slide-music-core"),
				  "base" => "swp_slide_link",
				  "class" => "",
				  "icon" => CDIR_URL . "visual_composer/vc_icons/vc_link.png",
				  "category" => esc_html__("Slide Elements", "slide-music-core"),
				  "params" => array(
					array(
						"type" => "textfield",
						"class" => "",
						"heading" => esc_html__("Link Text", "slide-music-core"),
						"param_name" => "link_text",
						"value" => "view more",
						"description" => esc_html__("Text shown.", "slide-music-core"),
						"admin_label"	=> true
					),
					array(
						"type" => "textfield",
						"class" => "",
						"heading" => esc_html__("Link URL", "slide-music-core"),
						"param_name" => "link_url",
						"value" => "#"
					),
					array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__("Open Link In", "slide-music-core"),
						"param_name" => "link_target",
						"value" => array(
							"Self Window"	=> "_self",
							"New Window"		=> "_blank"
						),
						"description" => esc_html__("Choose where to open the link.", "slide-music-core")
					),
					array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__("Text align", "slide-music-core"),
						"param_name" => "text_align",
						"value" => array(
							"Center"	=> "text_center",
							"Left"		=> "text_left",
							"Rigth"		=> "text_right"
						),
						"description" => esc_html__("How to align the link.", "slide-music-core")
					),
					array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__("Show Arrow", "slide-music-core"),
						"param_name" => "show_arrow",
						"value" => array(
							"Show an arrow at the end"	=> "show_arrow",
							"Do not show the arrow"		=> "no_arrow"
						),
						"description" => esc_html__("Choose to show an arrow at the end of the link.", "slide-music-core")
					)					
				 )
			));		
	}
}

if (shortcode_exists('swp_slide_button_scd')) {
	add_action('vc_before_init', 'SLIDE_SWP_swp_swp_slide_button_scd_map');
	function SLIDE_SWP_swp_swp_slide_button_scd_map() {
			vc_map(array(
				  "name" => esc_html__("Slide Button", "slide-music-core"),
				  "base" => "swp_slide_button_scd",
				  "class" => "",
				  "icon" => CDIR_URL . "visual_composer/vc_icons/vc_link.png",
				  "front_enqueue_js" => CDIR_URL . "visual_composer/js/front_enqueue/swp_slide_button_scd.js",
				  "category" => esc_html__("Slide Elements", "slide-music-core"),
				  "params" => array(
					array(
						"type" => "textfield",
						"class" => "",
						"heading" => esc_html__("Button Text", "slide-music-core"),
						"param_name" => "btn_text",
						"value" => "view more",
						"description" => esc_html__("Text shown on button.", "slide-music-core"),
						"admin_label"	=> true
					),
					array(
						"type" => "vc_link",
						"class" => "",
						"heading" => esc_html__("Button URL", "slide-music-core"),
						"param_name" => "btn_link",
						"value" => "#"
					),
					array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => esc_html__("Button Text Color", "slide-music-core"),
						"param_name" => "btn_txt_col",
						"value" => "#ffffff"
					),
					array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => esc_html__("Button Background Color", "slide-music-core"),
						"param_name" => "btn_bg_col",
						"value" => "#fb3a64"
					),
					array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => esc_html__("Button Border Color", "slide-music-core"),
						"param_name" => "btn_border_col",
						"value" => "#fb3a64"
					),
					array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => esc_html__("Button Text Hover Color", "slide-music-core"),
						"param_name" => "btn_txt_hover_col",
						"value" => "#ffffff"
					),
					array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => esc_html__("Button Background Hover Color", "slide-music-core"),
						"param_name" => "btn_bg_hover_col",
						"value" => "rgba(251,58,100,0)"
					),
					array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => esc_html__("Button Border Hover Color", "slide-music-core"),
						"param_name" => "btn_border_hover_col",
						"value" => "#fb3a64"
					),
					array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__("Align Button", "slide-music-core"),
						"param_name" => "btn_center",
						"value" => array(
							"Center"	=> "text_center",
							"Left"		=> "text_left",
							"Right"		=> "text_right"
						)
					),
					array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__("Button Corners", "slide-music-core"),
						"param_name" => "btn_corners",
						"value" => array(
							"Square"		=> "btn_square",
							"Rounded"	=> "btn_rounded"
						)
					)				
				 )
			));		
	}
}

if (shortcode_exists('swp_single_video')) {
	add_action('vc_before_init', 'SLIDE_SWP_swp_single_video_map');
	function SLIDE_SWP_swp_single_video_map() {
			$video_dropdown = SLIDE_SWP_get_post_dropdown("js_videos");

			vc_map(array(
				  "name" => esc_html__("Single Video", "slide-music-core"),
				  "base" => "swp_single_video",
				  "class" => "",
				  "icon" => CDIR_URL . "visual_composer/vc_icons/vc_video.png",
				  "category" => esc_html__("Slide Elements", "slide-music-core"),
				  "front_enqueue_js" => CDIR_URL . "visual_composer/js/front_enqueue/swp_single_video.js",
				  "params" => array(
					array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__("Choose Video", "slide-music-core"),
						"param_name" => "video_id",
						"value" => $video_dropdown,
						"admin_label"	=> true
					),				  	
					array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__("Background Image Source", "slide-music-core"),
						"param_name" => "use_bg_img",
						"value" => array(
							"Video Post Thumbnail"	=> "post_thumbnail",
							"Custom Image"		=> "custom"
						),
						"description" => esc_html__("Choose the source of the background image ", "slide-music-core")
					),
		            array(
		                "type"        => "attach_image",
		                "class"       => "",
		                "heading"     => esc_html__("Custom Background Image", "slide-swp-core"),
		                "param_name"  => "custom_bg_img",
		                "value"       => "",
		                "description" => esc_html__("Choose a custom background image.", "slide-swp-core"),
						'dependency' => array(
							'element' => 'use_bg_img',
							'value'   => 'custom'
						)
					)
				)
			));		
	}	
}

if (shortcode_exists('swp_video_btn')) {
	add_action('vc_before_init', 'SLIDE_SWP_swp_video_btn_map');
	function SLIDE_SWP_swp_video_btn_map() {
			$video_dropdown = SLIDE_SWP_get_post_dropdown("js_videos");

			vc_map(array(
				  "name" => esc_html__("Video Play", "slide-music-core"),
				  "base" => "swp_video_btn",
				  "class" => "",
				  "icon" => CDIR_URL . "visual_composer/vc_icons/vc_video.png",
				  "category" => esc_html__("Slide Elements", "slide-music-core"),
				  "params" => array(
					array(
						"type" => "textfield",
						"class" => "",
						"heading" => esc_html__("YouTube Short URL", "slide-music-core"),
						"param_name" => "video_youtube",
						"value" => "",
						"admin_label"	=> true,
						"description" => esc_html__("YouTube URL in SHORT form.", "slide-swp-core"),
					),				  	
					array(
						"type" => "textfield",
						"class" => "",
						"heading" => esc_html__("Viemo URL", "slide-music-core"),
						"param_name" => "video_vimeo",
						"value" => "",
						"admin_label"	=> true,
						"description" => esc_html__("Vimeo URL. If YouTube URL is not empty, it will be used instead of this source.", "slide-swp-core"),
					),
					array(
						"type" => "textfield",
						"class" => "",
						"heading" => esc_html__("Text", "slide-music-core"),
						"param_name" => "button_text",
						"value" => "Watch Now",
						"admin_label"	=> true,
						"description" => esc_html__("Text shown just after the play button.", "slide-swp-core"),
					),
			        array(
			            'type' => 'css_editor',
			            'heading' => esc_html__( 'CSS', 'slide-music-core' ),
			            'param_name' => 'css',
			            'group' => esc_html__( 'Design options', 'slide-music-core' ),
			        )				
				)
			));		
	}	
}

if (shortcode_exists("swp_horizontal_separator")) {
	add_action('vc_before_init', 'SLIDE_SWP_swp_horizontal_separator_map');
	function SLIDE_SWP_swp_horizontal_separator_map() {
		vc_map(array(
			  "name" => esc_html__("Horizontal Separator", "slide-music-core"),
			  "base" => "swp_horizontal_separator",
			  "class" => "",
			  "icon" => CDIR_URL . "visual_composer/vc_icons/vc_horizontal_sep.png",
			  "category" => esc_html__("Slide Elements", "slide-music-core"),
			  "front_enqueue_js" => CDIR_URL . "visual_composer/js/front_enqueue/swp_horizontal_separator.js",
			  "params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Separator Width", "slide-music-core"),
					"param_name" => "sep_width",
					"value" => "70px",
					"admin_label"	=> true,
					"description" => esc_html__("Separator width in pixels.", "slide-music-core")
				),				  	
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_html__("Align Separator", "slide-music-core"),
					"param_name" => "sep_align",
					"value" => array(
						"Align Left"	=> "align_left",
						"Align Right"	=> "align_right",
						"Align Center"	=> "align_center"
					)
				)
			)
		));
	}
}

	
if (shortcode_exists("swp_single_album_scd")) {
	add_action('vc_before_init', 'SLIDE_SWP_swp_single_album_scd_map');
	function SLIDE_SWP_swp_single_album_scd_map() {
		$albums_dropdown = SLIDE_SWP_get_post_dropdown("js_albums");
		vc_map(array(
			  "name" => esc_html__("Single Album", "slide-music-core"),
			  "base" => "swp_single_album_scd",
			  "class" => "",
			  "icon" => CDIR_URL . "visual_composer/vc_icons/vc_music_album.png",
			  "category" => esc_html__("Slide Elements", "slide-music-core"),
			  "front_enqueue_js" => CDIR_URL . "visual_composer/js/front_enqueue/swp_single_album_scd.js",
			  "params" => array(
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_html__("Choose Album", "slide-music-core"),
					"param_name" => "album_id",
					"value" => $albums_dropdown,
					"admin_label"	=> true
				),				  	
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Width", "slide-music-core"),
					"param_name" => "percent_width",
					"value" => "100%",
					"admin_label"	=> true,
					"description" => esc_html__("Width in percent from the parent element.", "slide-music-core")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_html__("Align Element", "slide-music-core"),
					"param_name" => "align",
					"value" => array(
						"Align Left"	=> "align_left",
						"Align Right"	=> "align_right"
					)
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Padding Left", "slide-music-core"),
					"param_name" => "padding_left",
					"value" => "0px",
					"group"	=> esc_html__("Design", "slide-music-core"),
					"description" => esc_html__("Padding value in pixels.", "slide-music-core")
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Padding Right", "slide-music-core"),
					"param_name" => "padding_right",
					"value" => "0px",
					"group"	=> esc_html__("Design", "slide-music-core"),
					"description" => esc_html__("Padding value in pixels.", "slide-music-core")
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Padding Top", "slide-music-core"),
					"param_name" => "padding_top",
					"value" => "0px",
					"group"	=> esc_html__("Design", "slide-music-core"),
					"description" => esc_html__("Padding value in pixels.", "slide-music-core")
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Padding Bottom", "slide-music-core"),
					"param_name" => "padding_bottom",
					"value" => "0px",
					"group"	=> esc_html__("Design", "slide-music-core"),
					"description" => esc_html__("Padding value in pixels.", "slide-music-core")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_html__("Ignore Paddings On Mobile", "slide-music-core"),
					"param_name" => "ignore_pad_on_mob",
					"group"	=> esc_html__("Design", "slide-music-core"),
					"value" => array(
						"Ingnore Paddings"	=> "ignore_padding_on_mobile",
						"Apply Paddings"	=> "apply_padding_on_mobile"
					),
					"description" => esc_html__("Ignore above paddings for mobile devices.", "slide-music-core")
				)
			)
		));
	}
}

if (shortcode_exists("swp_latest_albums")) {
	add_action('vc_before_init', 'SLIDE_SWP_swp_latest_albums_map');
	function SLIDE_SWP_swp_latest_albums_map() {
		$artist_dropdown = SLIDE_SWP_get_post_dropdown("js_artist");
		vc_map(array(
			  "name" => esc_html__("Latest Albums", "slide-music-core"),
			  "base" => "swp_latest_albums",
			  "category" => esc_html__("Slide Elements", "slide-music-core"),
			  "content_element" => true,
			  "class" => "",
			  "icon" => CDIR_URL . "visual_composer/vc_icons/vc_music_album.png",
			  'front_enqueue_js' => array(CDIR_URL . '/visual_composer/js/front_enqueue/swp_latest_albums.js'),
			  "params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Number of Albums", "slide-music-core"),
					"param_name" => "albumsnumber",
					"value" => "5",
					"admin_label"	=> true,
					"description" => esc_html__("Number of albums to show", "slide-music-core")
				),
				array(
					"type" => "swp_album_cat",
					"heading" => esc_html__( "Album Category", "slide-music-core"),
					"param_name" => "album_category",
					"value" =>  "",
					"admin_label"	=> true,
					"description" => esc_html__("Show only albums from this category.", "slide-music-core")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_html__( "Artist Name", "slide-music-core"),
					"param_name" => "artist_id",
					"value" =>  $artist_dropdown,
					"admin_label"	=> true,
					"description" => esc_html__("Show only albums for this artist.", "slide-music-core")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_html__( "Emphasize First", "slide-music-core"),
					"param_name" => "emphasize_first",
					"value"		=> array( 
									esc_html__("Yes", "slide-music-core") => "yes",
									esc_html__("No", "slide-music-core") => "no"
								)
				)
			  )
		));		
	}	
}

if (shortcode_exists("swp_latest_albums_vinyl")) {
	add_action('vc_before_init', 'SLIDE_SWP_swp_latest_albums_vinyl_map');
	function SLIDE_SWP_swp_latest_albums_vinyl_map() {
		$artist_dropdown = SLIDE_SWP_get_post_dropdown("js_artist");
		vc_map(array(
			  "name" => esc_html__("Latest Albums (Vinyl)", "slide-music-core"),
			  "base" => "swp_latest_albums_vinyl",
			  "category" => esc_html__("Slide Elements", "slide-music-core"),
			  "content_element" => true,
			  "class" => "",
			  "icon" => CDIR_URL . "visual_composer/vc_icons/vc_music_album.png",
			  'front_enqueue_js' => array(CDIR_URL . '/visual_composer/js/front_enqueue/swp_latest_albums_vinyl.js'),
			  "params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Number of Albums", "slide-music-core"),
					"param_name" => "albumsnumber",
					"value" => "3",
					"admin_label"	=> true,
					"description" => esc_html__("Number of albums to show", "slide-music-core")
				),
				array(
					"type" => "swp_album_cat",
					"heading" => esc_html__( "Album Category", "slide-music-core"),
					"param_name" => "album_category",
					"value" =>  "",
					"admin_label"	=> true,
					"description" => esc_html__("Show only albums from this category.", "slide-music-core")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_html__( "Artist Name", "slide-music-core"),
					"param_name" => "artist_id",
					"value" =>  $artist_dropdown,
					"admin_label"	=> true,
					"description" => esc_html__("Show only albums for this artist.", "slide-music-core")
				)
			  )
		));		
	}	
}

if (shortcode_exists('swp_last_events_scd')) {
	add_action( 'vc_before_init', 'SLIDE_SWP_swp_last_events_scd_map' );
	function SLIDE_SWP_swp_last_events_scd_map() {
		$artist_dropdown = SLIDE_SWP_get_post_dropdown("js_artist");

		vc_map( array(
			  "name" => esc_html__("Events", "slide-music-core"),
			  "base" => "swp_last_events_scd",
			  "class" => "",
			  "icon" => CDIR_URL . "visual_composer/vc_icons/vc_event.png",
			  "category" => esc_html__("Slide Elements", "slide-music-core"),
			  "params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__( "View all text message", "slide-music-core"),
					"param_name" => "viewallmessage",
					"value" => "View All Shows",
					"description" => esc_html__("View all text message shown under the event list.", "slide-music-core")
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__( "Events Page URL", "slide-music-core"),
					"param_name" => "eventspageurl",
					"value" => "",
					"description" => esc_html__("URL to Events page.", "slide-music-core")
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__( "Number of Events", "slide-music-core"),
					"param_name" => "eventsnumber",
					"admin_label"	=> true,
					"value" => "4",
					"description" => esc_html__("Number of Events Displayed.", "slide-music-core")
				),
				array(
					"type" => "swp_event_cat",
					"class" => "",
					"heading" => esc_html__("Event Category", "slide-music-core"),
					"param_name" => "event_category",
					"admin_label"	=> true,
					"value" => "",
					"description" => esc_html__("Choose the event category. By default, events from all categories are shown.", "slide-music-core")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_html__( "Show Events", "slide-music-core"),
					"param_name" => "past_next",
					"value" =>  array( 
									"Upcoming" => "next",
									"Past" => "past"
								),
					"admin_label"	=> true,
					"description" => esc_html__("Choose to display upcoming or past events.", "slide-music-core")
				),					
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_html__( "Artist Name", "slide-music-core"),
					"param_name" => "artist_id",
					"value" =>  $artist_dropdown,
					"admin_label"	=> true,
					"description" => esc_html__("Select the artist.", "slide-music-core")
				)
			  )
		));
	}
}

if (shortcode_exists('swp_last_events_cards_scd')) {
	add_action( 'vc_before_init', 'SLIDE_SWP_swp_last_events_cards_scd_map' );
	function SLIDE_SWP_swp_last_events_cards_scd_map() {
		$artist_dropdown = SLIDE_SWP_get_post_dropdown("js_artist");

		vc_map( array(
			  "name" => esc_html__("Events (Cards)", "slide-music-core"),
			  "base" => "swp_last_events_cards_scd",
			  "class" => "",
			  "icon" => CDIR_URL . "visual_composer/vc_icons/vc_event.png",
			  'front_enqueue_js' => array(CDIR_URL . '/visual_composer/js/front_enqueue/swp_last_events_cards_scd.js'),
			  "category" => esc_html__("Slide Elements", "slide-music-core"),
			  "params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__( "Number of Events", "slide-music-core"),
					"param_name" => "eventsnumber",
					"admin_label"	=> true,
					"value" => "4",
					"description" => esc_html__("Number of Events Displayed.", "slide-music-core")
				),
				array(
					"type" => "swp_event_cat",
					"class" => "",
					"heading" => esc_html__("Event Category", "slide-music-core"),
					"param_name" => "event_category",
					"admin_label"	=> true,
					"value" => "",
					"description" => esc_html__("Choose the event category. By default, events from all categories are shown.", "slide-music-core")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_html__( "Show Events", "slide-music-core"),
					"param_name" => "past_next",
					"value" =>  array( 
									"Upcoming" => "next",
									"Past" => "past"
								),
					"admin_label"	=> true,
					"description" => esc_html__("Choose to display upcoming or past events.", "slide-music-core")
				),					
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_html__( "Artist Name", "slide-music-core"),
					"param_name" => "artist_id",
					"value" =>  $artist_dropdown,
					"admin_label"	=> true,
					"description" => esc_html__("Select the artist.", "slide-music-core")
				)
			  )
		));
	}
}

if (shortcode_exists("swp_event_countdown")) {
	add_action('vc_before_init', 'SLIDE_SWP_swp_event_countdown_map');
	function SLIDE_SWP_swp_event_countdown_map() {
		vc_map(array(
			  "name" => esc_html__("Next Event CountDown", "slide-music-core"),
			  "base" => "swp_event_countdown",
			  "category" => esc_html__("Slide Elements", "slide-music-core"),
			  "content_element" => true,
			  "class" => "",
			  "icon" => CDIR_URL . "visual_composer/vc_icons/vc_event.png",
			  "params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Countdown Text", "slide-music-core"),
					"param_name" => "countdown_text",
					"value" => "Next Big Show",
					"admin_label"	=> true,
					"description" => esc_html__("Text shown above the event title", "slide-music-core")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_html__( "Overlap Previous", "slide-music-core"),
					"param_name" => "overlap_prev",
					"value"		=> array( 
									esc_html__("No", "slide-music-core") => "no_overlap",
									esc_html__("Yes - Overlap Previous Element", "slide-music-core") => "overlap_prev"
								)
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_html__( "Layout Style", "slide-music-core"),
					"param_name" => "layout_style",
					"value"		=> array( 
									esc_html__("Vibrant Color As Background", "slide-music-core") => "vibrant_bg",
									esc_html__("Transparent Background", "slide-music-core") => "transparent_bg"
								)
				)
			  )
		));		
	}
}


if (shortcode_exists('swp_latest_artists_scd')) {
	add_action( 'vc_before_init', 'SLIDE_SWP_swp_latest_artists_scd_map' );
	function SLIDE_SWP_swp_latest_artists_scd_map() {
		$artist_dropdown = SLIDE_SWP_get_post_dropdown("js_artist");

		vc_map( array(
			  "name" => esc_html__("Artists", "slide-music-core"),
			  "base" => "swp_latest_artists_scd",
			  "class" => "",
			  "icon" => CDIR_URL . "visual_composer/vc_icons/vc_users.png",
			  "front_enqueue_js" => CDIR_URL . "visual_composer/js/front_enqueue/swp_latest_artists_scd.js",
			  "category" => esc_html__("Slide Elements", "slide-music-core"),
			  "params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__( "Number of Artists", "slide-music-core"),
					"param_name" => "artistsnumber",
					"admin_label"	=> true,
					"value" => "4",
					"description" => esc_html__("Number of Artists Displayed.", "slide-music-core")
				),
				array(
					"type" => "swp_artist_cat",
					"class" => "",
					"heading" => esc_html__("Artist Category", "slide-music-core"),
					"param_name" => "artist_category",
					"admin_label"	=> true,
					"value" => "",
					"description" => esc_html__("Choose the artist category. By default, artists from all categories are shown.", "slide-music-core")
				)
			  )
		));
	}
}

if (shortcode_exists('swp_review_container_scd')) {
	add_action('vc_before_init', 'SLIDE_SWP_swp_review_container_scd_map');
	function SLIDE_SWP_swp_review_container_scd_map() {
		vc_map( array(
				"name" => esc_html__("Reviews Slider", "slide-music-core"),
				"base" => "swp_review_container_scd",
				"as_parent" => array('only' => 'swp_user_review_scd'),
				"content_element" => true,
				"show_settings_on_create" => true,
				"is_container" => true,
				"js_view" => 'VcColumnView',
				"class" => "",
				"icon" => CDIR_URL . "visual_composer/vc_icons/vc_review.png",
				"front_enqueue_js" => CDIR_URL . "visual_composer/js/front_enqueue/swp_review_container_scd.js",
				"category" => esc_html__("Slide Elements", "slide-music-core"),
				"params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__( "Slide Speed", "slide-music-core"),
					"param_name" => "slide_speed",
					"value" => "400",
					"description" => esc_html__("Slide speed in milliseconds. Use a value between 400 and 1000.", "slide-music-core")
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Slide Delay", "slide-music-core"),
					"param_name" => "slide_delay",
					"value" => "4000",
					"description" => esc_html__("Slide delay in milliseconds. Use a value between 1000 and 10000.", "slide-music-core")
				)
			  )
		));
	}

	if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
		class WPBakeryShortCode_swp_review_container_scd extends WPBakeryShortCodesContainer {
		}
	}
}

if (shortcode_exists('swp_user_review_scd')) {
	add_action('vc_before_init', 'SLIDE_SWP_swp_user_review_scd_map');
	function SLIDE_SWP_swp_user_review_scd_map() {
		vc_map(array(
			  "name" => esc_html__("User Review", "slide-music-core"),
			  "base" => "swp_user_review_scd",
			  "content_element" => true,
			  "class" => "",
			  "icon" => CDIR_URL . "visual_composer/vc_icons/vc_user_single.png",
			  "as_child" => array('only' => 'swp_review_container_scd'),
			  "params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Reviewer Name", "slide-music-core"),
					"param_name" => "reviewer_name",
					"value" => "Martin Stanley",
					"admin_label"	=> true,
					"description" => esc_html__("Reviewer Name", "slide-music-core")
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Reviewer Position", "slide-music-core"),
					"param_name" => "reviewer_position",
					"value" => "Manager",
					"admin_label"	=> true,
					"description" => esc_html__("Reviewer Name - ex. Spotify Manager", "slide-music-core")
				),
				array(
					"type" => "attach_image",
					"class" => "",
					"heading" => esc_html__( "Reviewer Image", "slide-music-core"),
					"param_name" => "reviewer_image",
					"value" => "",
					"description" => esc_html__("Image for the review author", "slide-music-core")
				),
				array(
					"type" => "textarea",
					"class" => "",
					"heading" => esc_html__( "Review Content", "slide-music-core"),
					"param_name" => "review_content",
					"value"		=> "We just want to say thank you...",
					"admin_label"	=> true,
					"description" => esc_html__("Review Content", "slide-music-core")
				)
			  )
		));
	}
}

if (shortcode_exists('swp_blog_scd')) {
	add_action('vc_before_init', 'SLIDE_SWP_swp_blog_scd_map');
	function SLIDE_SWP_swp_blog_scd_map() {
		vc_map(array(
			  "name" => esc_html__("Blog Posts", "slide-music-core"),
			  "base" => "swp_blog_scd",
			  "class" => "",
			  "icon" => CDIR_URL . "visual_composer/vc_icons/vc_blog.png",
			  "category" => esc_html__("Slide Elements", "slide-music-core"),
			  "params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Number Of Posts", "slide-music-core"),
					"param_name" => "postsnumber",
					"value" => "3",
					"admin_label"	=> true,
					"description" => esc_html__("Number of posts to show.", "slide-music-core")
				),
				array(
					"type" => "swp_post_cat",
					"class" => "",
					"heading" => esc_html__("Post Category", "slide-music-core"),
					"param_name" => "post_category",
					"value" => "",
					"admin_label"	=> true,
					"description" => esc_html__("Choose the post category. By default, posts from all categories are shown.", "slide-music-core")
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Excerpt length", "slide-music-core"),
					"param_name" => "user_excerpt_length",
					"value" => "17",
					"admin_label"	=> true,
					"description" => esc_html__("Number of words that the short description shoud have (excerpt). Use an integer value between 0 and 20. Default - 17 words.", "slide-music-core")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_html__( "Show Posts Thumbnails", "slide-music-core"),
					"param_name" => "show_post_thumbnails",
					"value" =>  array( 
									"Show Thumbnails" => "show_thumbnails",
									"Hide Thumbnails" => "hide_thumbnails"
								),
					"admin_label"	=> true,
					"description" => esc_html__("Choose to show or hide the post thumbnails.", "slide-music-core")
				)
			  )
		));
	}
}

if (shortcode_exists('swp_mailchimp_subscribe')) {
	add_action( 'vc_before_init', 'SLIDE_SWP_swp_mailchimp_subscribe_map');
	function SLIDE_SWP_swp_mailchimp_subscribe_map() {
		vc_map( array(
			"name" => esc_html__("MailChimp Subscribe Form", "slide-music-core"),
			"base" => "swp_mailchimp_subscribe",
			'icon'=> CDIR_URL . 'visual_composer/vc_icons/vc_mailchimp.png',
			"category" => esc_html__("Slide Elements", "slide-music-core"),
			"front_enqueue_js" => CDIR_URL . "visual_composer/js/front_enqueue/swp_mailchimp_subscribe.js",
			"description" => esc_html__("Make sure you fill the api key and list id to Settings - Slide Music Core Settings first.", "slide-music-core"),
			"params"	=> array(
			  	array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Button Text", "slide-music-core"),
					"param_name" => "button_text",
					"value" => "Subscribe",
					"description" => esc_html__("Text shown on button.", "slide-music-core")
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__( "Input Placeholder", "slide-music-core"),
					"param_name" => "input_placeholder",
					"value" => "Email Address",
					"description" => esc_html__("Placeholder text shown on input field.", "slide-music-core")
				),
				array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => esc_html__( "Background Color", "slide-music-core"),
					"param_name" => "bg_color",
					"value" => "rgba(9, 9, 47, 0.7)",
					"description" => esc_html__("Form background color.", "slide-music-core")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_html__( "Element Width", "slide-music-core"),
					"param_name" => "width",
					"value" =>  array( 
									"Default" => "default",
									"Custom" => "custom"
								)
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__( "Pixel Width", "slide-music-core"),
					"param_name" => "user_px_width",
					"value" => "",
					"description" => esc_html__("Element width in pixels.", "slide-music-core"),
					'dependency' => array(
						'element' => 'width',
						'value'   => 'custom'
					)
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_html__( "Align", "slide-music-core"),
					"param_name" => "align",
					"value" =>  array( 
									"Left" => "left",
									"Center" => "center"
								),
					'dependency' => array(
						'element' => 'width',
						'value'   => 'custom'
					)
				)
			)
		));
	}
}

if (shortcode_exists("swp_slide_player")) {
	add_action( 'vc_before_init', 'SLIDE_SWP_swp_slide_player_map');
	function SLIDE_SWP_swp_slide_player_map() {
			vc_map( array(
				"name" => esc_html__("Slide Music Player", "slide-music-core"),
				"base" => "swp_slide_player",
				"category" => esc_html__("Slide Elements", "slide-music-core"),
				"as_parent" => array('only' => 'swp_music_player_entry'), /* Use only|except attributes to limit child shortcodes (separate multiple values with comma)*/
				"content_element" => true,
				"show_settings_on_create" => true,
				"is_container" => true,
				"js_view" => 'VcColumnView',
				"front_enqueue_js" => CDIR_URL . "visual_composer/js/front_enqueue/swp_slide_player.js",
				"icon" => CDIR_URL . "visual_composer/vc_icons/vc_play.png",
				"params" => array(
					array(
						"type" => "attach_image",
						"class" => "",
						"heading" => esc_html__("Album Cover Image", "slide-music-core"),
						"param_name" => "album_cover_img",
						"value" => "",
						"description" => esc_html__("Attach the album cover.", "slide-music-core")
					),
					array(
						"type" => "attach_image",
						"class" => "",
						"heading" => esc_html__("Playlist Cover Image", "slide-music-core"),
						"param_name" => "playlist_bg_img",
						"value" => "",
						"description" => esc_html__("Attach a background image for the playlist area.", "slide-music-core")
					),
					array(
						"type" => "textfield",
						"class" => "",
						"heading" => esc_html__( "Playlist title", "slide-music-core"),
						"param_name" => "album_title",
						"value" => "Last Man Standing",
						"description" => esc_html__("Add a title for your playlist/album.", "slide-music-core")
					),
					array(
						"type" => "textfield",
						"class" => "",
						"heading" => esc_html__( "Featured text", "slide-music-core"),
						"param_name" => "featured_text",
						"value" => "Featured Album",
						"description" => esc_html__("Add a text shown above the title.", "slide-music-core")
					),
					array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => esc_html__( "Hover Color", "slide-music-core"),
					"param_name" => "hover_color",
					"value" => "#0a0a30",
					"description" => esc_html__("Choose the background color shown when hover on some player entry.", "slide-music-core")
					),
					array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__( "Autoplay", "slide-music-core"),
						"param_name" => "autoplay",
						"value"		=> array( 
										esc_html__("No", "slide-music-core") => "no",
										esc_html__("Yes", "slide-music-core") => "yes"
									)
					),
					array(
						"type" => "textfield",
						"class" => "",
						"heading" => esc_html__( "Player buy button text", "slide-music-core"),
						"param_name" => "album_buy_text",
						"value" => "Buy On Itunes",
						"description" => esc_html__("Add a text shown on the buy button situated at the top of the player.", "slide-music-core")
					),
					array(
						"type" => "textfield",
						"class" => "",
						"heading" => esc_html__( "Player buy button URL", "slide-music-core"),
						"param_name" => "album_buy_url",
						"value" => "#",
						"description" => esc_html__("Add the URL shown on the buy button situated at the top of the player. Let this empty if you don't want to show the button.", "slide-music-core")
					),
					array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__( "Button Icon", "slide-music-core"),
						"param_name" => "button_buy_icon",
						"value"		=> array( 
										esc_html__("None", "slide-music-core") => "none",
										esc_html__("Apple", "slide-music-core") => "apple",
										esc_html__("Amazon", "slide-music-core") => "amazon",
										esc_html__("Spotify", "slide-music-core") => "spotify",
										esc_html__("Google Play", "slide-music-core") => "google-play"
									)
					),
					array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__( "Overlap Previous", "slide-music-core"),
						"param_name" => "overlap_prev",
						"value"		=> array( 
										esc_html__("No", "slide-music-core") => "no_overlap",
										esc_html__("Yes - Overlap Previous Element", "slide-music-core") => "overlap_prev"
									),
						"description" => esc_html__("Choose to overlap the previous layout element. Ex. overlaping the slider.", "slide-music-core")
					)
				  )
			));
	}

	if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
		class WPBakeryShortCode_Swp_Slide_Player extends WPBakeryShortCodesContainer {
		}
	}	
}

if (shortcode_exists("swp_music_player_entry")) {
	add_action('vc_before_init', 'SLIDE_SWP_swp_music_player_entry_map');
	function SLIDE_SWP_swp_music_player_entry_map() {
		vc_map(array(
			  "name" => esc_html__("Player Entry", "slide-music-core"),
			  "base" => "swp_music_player_entry",
			  "content_element" => true,
			  "class" => "",
			  "icon" => CDIR_URL . "visual_composer/vc_icons/vc_music_list.png",
			  'admin_enqueue_js' => array(CDIR_URL . '/visual_composer/js/map_elements.js'),
			  'admin_enqueue_css' => array(CDIR_URL . '/visual_composer/css/map_elements.css'),
			  'front_enqueue_css' => array(CDIR_URL . '/visual_composer/css/map_elements.css'),
			  "as_child" => array('only' => 'swp_slide_player'),
			  "params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__("Song Name", "slide-music-core"),
					"param_name" => "song_name",
					"value" => "",
					"admin_label"	=> true,
					"description" => esc_html__("Song Name", "slide-music-core")
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__( "Amazon Buy URL", "slide-music-core"),
					"param_name" => "amazon_buy_url",
					"value" => "",
					"description" => esc_html__("URL where the visitor can buy or download song.", "slide-music-core")
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__( "Spotify Buy URL", "slide-music-core"),
					"param_name" => "spotify_buy_url",
					"value" => "",
					"description" => esc_html__("URL where the visitor can buy or download song.", "slide-music-core")
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__( "Apple Buy URL", "slide-music-core"),
					"param_name" => "apple_buy_url",
					"value" => "",
					"description" => esc_html__("URL where the visitor can buy or download song.", "slide-music-core")
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__( "Google Play Buy URL", "slide-music-core"),
					"param_name" => "gplay_buy_url",
					"value" => "",
					"description" => esc_html__("URL where the visitor can buy or download song.", "slide-music-core")
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__( "YouTube Promo URL", "slide-music-core"),
					"param_name" => "youtube_url",
					"value" => "",
					"description" => esc_html__("URL to your YouTube channel or song.", "slide-music-core")
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__( "SoundCloud Promo URL", "slide-music-core"),
					"param_name" => "soundcloud_url",
					"value" => "",
					"description" => esc_html__("URL to SoundCloud page.", "slide-music-core")
				),
				array(
					"type" => "swp_attach_music",
					"class" => "",
					"heading" => esc_html__( "Media File", "slide-music-core"),
					"param_name" => "media_file_id",
					"value" => "",
					"description" => esc_html__("Please attach a media file in mp3 format.", "slide-music-core")
				)
			  )
		));		
	}

	if ( class_exists( 'WPBakeryShortCode' ) ) {
		class WPBakeryShortCode_Swp_Music_Player_Entry extends WPBakeryShortCode {
		}
	}	
}

if (shortcode_exists("swp_gallery_scd")) {
	add_action( 'vc_before_init', 'SLIDE_SWP_swp_gallery_scd_map' );
	function SLIDE_SWP_swp_gallery_scd_map() {
		vc_map( array(
			  "name" => esc_html__("Gallery", "slide-music-core"),
			  "base" => "swp_gallery_scd",
			  "class" => "",
			  "icon" => CDIR_URL . "visual_composer/vc_icons/vc_gallery.png",
			  "front_enqueue_js" => CDIR_URL . "visual_composer/js/front_enqueue/swp_gallery_scd.js",
			  "category" => esc_html__("Slide Elements", "slide-music-core"),
			  "params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_html__( "Row height in pixels", "slide-music-core"),
					"param_name" => "rowheight",
					"value" => "180",
					"admin_label"	=> true,
					"description" => esc_html__("Row height in pixels. Digits only. Default value: 180", "slide-music-core")
				),
				array(
					"type" => "attach_images",
					"class" => "",
					"heading" => esc_html__( "Add images", "slide-music-core"),
					"param_name" => "images",
					"value" => "",
					"description" => esc_html__("Add your images here", "slide-music-core")
				)
			  )
		));
	}
}

if (shortcode_exists('swp_contact_form_scd')) {
	add_action( 'vc_before_init', 'SLIDE_SWP_js_swp_contact_form_map' );
	function SLIDE_SWP_js_swp_contact_form_map() {
		vc_map( array(
			  "name" => esc_html__("Ajax Contact Form", "slide-music-core"),
			  "base" => "swp_contact_form_scd",
			  "class" => "",
			  "icon" => CDIR_URL . "visual_composer/vc_icons/vc_contact.png",
			  "category" => esc_html__("Slide Elements", "slide-music-core"),
			  "params" => array(
			  		array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__( "Input Styling", "slide-music-core"),
						"param_name" => "input_styling",
						"value" =>  array( 
										"One on Row" => "one_on_row",
										"Two on Row" => "two_on_row"
									),
						"admin_label"	=> true,
						"description" => esc_html__("Choose how to render the input fields", "slide-music-core")
					),
			  		array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__( "Button Style", "slide-music-core"),
						"param_name" => "button_style",
						"value" =>  array( 
										"Square" => "btn_square",
										"Rounded" => "btn_rounded"
									),
						"admin_label"	=> true
					)
				)
		));
	}
}

if (shortcode_exists('swp_contact_details_scd')) {
	add_action( 'vc_before_init', 'SLIDE_SWP_js_swp_contact_details_map' );
	function SLIDE_SWP_js_swp_contact_details_map() {
		vc_map( array(
			  "name" => esc_html__("Contact Data", "slide-music-core"),
			  "base" => "swp_contact_details_scd",
			  "class" => "",
			  "icon" => CDIR_URL . "visual_composer/vc_icons/vc_contact.png",
			  "category" => esc_html__("Slide Elements", "slide-music-core"),
			  "params" => array()
		));
	}
}

if (shortcode_exists('swp_social_profiles_icons_scd')) {
	add_action( 'vc_before_init', 'SLIDE_SWP_js_swp_social_profiles_icons_map' );
	function SLIDE_SWP_js_swp_social_profiles_icons_map() {
		vc_map( array(
			  "name" => esc_html__("Social Profiles Icons", "slide-music-core"),
			  "base" => "swp_social_profiles_icons_scd",
			  "class" => "",
			  "icon" => CDIR_URL . "visual_composer/vc_icons/vc_social.png",
			  "category" => esc_html__("Slide Elements", "slide-music-core"),
			  "params" => array(
			  		array(
						"type" => "dropdown",
						"class" => "",
						"heading" => esc_html__( "Align Icons", "slide-music-core"),
						"param_name" => "center_icons",
						"value" =>  array( 
							"Center" => "text_center",
							"Left" => "text_left",
							"Right" => "text_right",
						),
						"description" => esc_html__("Align icons center, left or right. Icons are selected automatically for the social networks filled in Slide Settings - Social Options.", "Slide-music-core")
					)
			  )
		));
	}
}
/*
	New Params For Visual Composer
*/
add_action( 'vc_before_init', 'SLIDE_SWP_add_new_vc_params' );
function SLIDE_SWP_add_new_vc_params() {
	if (!function_exists("vc_add_shortcode_param")) {
		return;
	}

	vc_add_shortcode_param('swp_post_cat', 'SLIDE_SWP_vc_param_post_cat');
	vc_add_shortcode_param('swp_event_cat', 'SLIDE_SWP_vc_param_event_cat');
	vc_add_shortcode_param('swp_album_cat', 'SLIDE_SWP_vc_param_album_cat');
	vc_add_shortcode_param('swp_artist_cat', 'SLIDE_SWP_vc_param_artist_cat');
	vc_add_shortcode_param('swp_attach_music', 'SLIDE_SWP_vc_attach_music', CDIR_URL . '/visual_composer/js/map_elements.js');
}
function SLIDE_SWP_vc_param_post_cat($settings, $value) {
	$args = array(
		'show_option_all'    => 'All',
		'class'              => 'wpb_vc_param_value',
		'name'               => $settings['param_name'],
		'selected'           => $value
	);

	ob_start();
	wp_dropdown_categories($args);
	$output = ob_get_clean();
	return $output;
}

function SLIDE_SWP_vc_param_event_cat($settings, $value) {
	$args = array(
		'taxonomy'           => 'event_category',
		'show_option_all'    => 'All',
		'class'              => 'wpb_vc_param_value',
		'name'               => $settings['param_name'],
		'selected'           => $value
	);

	ob_start();
	wp_dropdown_categories($args);
	$output = ob_get_clean();
	return $output;		
}

function SLIDE_SWP_vc_param_album_cat($settings, $value) {
	$args = array(
		'taxonomy'           => 'album_category',
		'show_option_all'    => 'All',
		'class'              => 'wpb_vc_param_value',
		'name'               => $settings['param_name'],
		'selected'           => $value
	);

	ob_start();
	wp_dropdown_categories($args);
	$output = ob_get_clean();
	return $output;			
}

function SLIDE_SWP_vc_param_artist_cat($settings, $value) {
	$args = array(
		'taxonomy'           => 'artist_category',
		'show_option_all'    => 'All',
		'class'              => 'wpb_vc_param_value',
		'name'               => $settings['param_name'],
		'selected'           => $value
	);

	ob_start();
	wp_dropdown_categories($args);
	$output = ob_get_clean();
	return $output;	
}

function SLIDE_SWP_vc_attach_music($settings, $value) {
	ob_start();

	$add_preview_class = "";
	if (!empty($value)) {
		$add_preview_class .= "show_song_title";
	}
	?>
    <input type="hidden" name="<?php echo esc_attr($settings['param_name']); ?>" 
    class="wpb_vc_param_value wpb-textinput <?php echo esc_attr($settings['param_name']).' '.esc_attr($settings['type']).'_field'; ?>" 
    value="<?php echo esc_attr($value); ?>"/>

    <div class="lc_wave_song_preview <?php echo esc_attr($add_preview_class); ?>">
    	<?php echo wp_basename(get_attached_file($value)); ?>
    </div>

    <div class="attach_music_buttons clearfix">
        <a class="swp_add_media_file_vc_btn" title="<?php echo esc_attr(esc_html__( "Add Music File", "slide-music-core"));?>" href="#">
        	<i class="vc-composer-icon vc-c-icon-add"></i>
        </a>

		<a class="swp_remove_media_file_vc_btn" title="<?php echo esc_attr(esc_html__( "Remove File", "slide-music-core"));?>" href="#">
        	<i class="vc-composer-icon vc-c-icon-close"></i>
        </a>
    </div>
	<?php
	$output = ob_get_clean();

	return $output;
}


function SLIDE_SWP_get_post_dropdown($post_name, $show_option_all = true) {
	if (!strlen($post_name)) {
		return array();
	}

	/*key(post_id)	=> value(post_name)*/
	$args = array(
			'numberposts'		=> 	-1,
			'orderby'          => 'post_date',
			'order'            => 'DESC',
			'post_type'        => $post_name,
			'post_status'      => 'publish',
			'suppress_filters' => false
		);
	$result_posts = get_posts($args);
	
	$posts_dropdown = array();
	if ($show_option_all) {
		$posts_dropdown["All"] = 0;
	}
	foreach($result_posts as $single_post) {
			$my_post_id = $single_post->ID;
			$my_post_name = $single_post->post_title;
			
			$posts_dropdown[$my_post_name] = $my_post_id;
	}
	wp_reset_postdata();

	return $posts_dropdown;
}