<?php

/*
	UTILITIES FUNCTIONS
*/
function SLIDE_SWP_get_current_page_id() {
	if (SLIDE_SWP_is_woocommerce_active()) {
		if (is_shop()) {
			return wc_get_page_id('shop');
		}
		if (is_account_page()) {
			return wc_get_page_id('myaccount');
		}
		if (is_checkout()) {
			return wc_get_page_id('checkout');	
		}
	}

	if (!in_the_loop()) {
    	/** @var $wp_query wp_query */
	    global $wp_query;
		return  $wp_query->get_queried_object_id();
	}

	return get_the_ID();
}

function SLIDE_SWP_get_page_custom_menu_style(&$page_logo, &$menu_bar_bg, &$menu_txt_col) {
	$post_id 		= SLIDE_SWP_get_current_page_id();
	$page_logo = $menu_bar_bg = $menu_txt_col = $above_menu_bg = $above_menu_txt_col = "";

	$page_logo 	= get_post_meta($post_id, 'lc_swp_meta_page_logo', true);
	$menu_bar_bg = get_post_meta($post_id, 'lc_swp_meta_page_menu_bg', true);
	$menu_txt_col = get_post_meta($post_id, 'lc_swp_meta_page_menu_txt_color', true);

	return (!empty($menu_bar_bg) ||
		!empty($menu_txt_col));
}

function SLIDE_SWP_get_translated_month($english_month_name) {

	switch (strtolower($english_month_name)) {
	    case "jan":
			return esc_html__("jan", 'slide');
	    case "feb":
			return esc_html__("feb", 'slide');
	    case "mar":
			return esc_html__("mar", 'slide');
	    case "apr":
			return esc_html__("apr", 'slide');
	    case "may":
			return esc_html__("may", 'slide');
	    case "jun":
			return esc_html__("jun", 'slide');
	    case "jul":
			return esc_html__("jul", 'slide');
	    case "aug":
			return esc_html__("aug", 'slide');
	    case "sep":
			return esc_html__("sep", 'slide');
	    case "oct":
			return esc_html__("oct", 'slide');
	    case "nov":
			return esc_html__("nov", 'slide');
	    case "dec":
			return esc_html__("dec", 'slide');
	}

	return $english_month_name;
}

function SLIDE_SWP_get_tax_name_by_post_type($post_type) {
	switch($post_type) {
		case "js_albums":
			return 'album_category';
		case 'js_events':
			return 'event_category';
		case 'js_photo_albums':
			return 'photo_album_category';
		case 'js_videos':
			return 'video_category';
		case 'js_artist':
			return 'artist_category';			
		default:
			return 'category';
	}
}

function SLIDE_SWP_get_tax_name_by_page_template($page_template) {
	switch ($page_template) {
		case 'template-events-past.php':
		case 'template-events-upcoming.php':
		case 'template-events-all.php':
			return SLIDE_SWP_get_tax_name_by_post_type('js_events');
		case 'template-photo-gallery.php':
			return SLIDE_SWP_get_tax_name_by_post_type('js_photo_albums');
		case 'template-videos.php':
			return SLIDE_SWP_get_tax_name_by_post_type('js_videos');
		case 'template-discography.php':
			return SLIDE_SWP_get_tax_name_by_post_type('js_albums');
		case 'template-artists.php':
			return SLIDE_SWP_get_tax_name_by_post_type('js_artist');
		default:
			return 'category';
	}
}

function SLIDE_SWP_getIDFromShortURL($short_url) {
	$elements = explode("/", $short_url);
	$dim = count($elements); 
	
	if ($dim == 0) {
		return "";
	} else {
		return $elements[$dim - 1];
	}
}

function SLIDE_SWP_get_specific_color_scheme() {
	$global_color_scheme = SLIDE_SWP_get_default_color_scheme();

	/*page specific scheme*/
	$post_id 		= SLIDE_SWP_get_current_page_id();
	$page_specific_scheme = get_post_meta($post_id, 'lc_swp_meta_page_color_theme', true);
	
	if (empty($page_specific_scheme)) {
		return $global_color_scheme;
	}

	if ("settings_default" != $page_specific_scheme) {
		return $page_specific_scheme;
	}

	return $global_color_scheme;
}

/*WooCommerce Stuff*/
function SLIDE_SWP_is_woocommerce_active() {
	if (class_exists('woocommerce')) {
		return true;
	}

	return false;
}

function SLIDE_SWP_is_woocommerce_special_page() {
	if (!SLIDE_SWP_is_woocommerce_active()) {
		return false; 
	}

	if (function_exists("is_shop")) {
		if (is_shop()) {
			return true;
		}
	}
	if (function_exists("is_product")) {
		if (is_product()) {
			return true;
		}
	}
	if (function_exists("is_cart")) {
		if (is_cart()) {
			return true;
		}
	}

	return false;
}

function SLIDE_SWP_is_product_archive() {
	if (!SLIDE_SWP_is_woocommerce_active()) {
		return false;
	}

	if (is_shop()) {
		return true;
	}

	return false;
}

function SLIDE_SWP_has_side_menu() {
	return is_active_sidebar('swp-side-menu');
}

function SLIDE_SWP_show_custom_cat($page_id) {
	if (!$page_id) {
		return false;
	}

	if(!strlen($page_id)) {
		return false;
	}

	$show_meta = get_post_meta($page_id, 'swp_show_cpt_cat', true);
	if (empty($show_meta)) {
		return false;
	}

	return ("yes" == $show_meta) ? true : false;
}

function SLIDE_SWP_set_title_and_centering_for_cpt_tax(&$title, &$subtitle, &$heading_style) {
	$cpt_tax = "";
	$archive_page_id = "";
	if (!SLIDE_SWP_is_cpt_tax($cpt_tax, $archive_page_id)) {
		return false;
	}

	/*page id is set in theme settings*/
	if ($archive_page_id) {
		/*get the properties of the archive page only if it shows the custom cat*/
		if (SLIDE_SWP_show_custom_cat($archive_page_id)) {
			$title			= get_the_title($archive_page_id);
			$subtitle 		= esc_html(get_post_meta($archive_page_id, 'lc_swp_meta_subtitle', true));		
			$heading_style 	= get_post_meta($archive_page_id, 'lc_swp_meta_heading_full_color', true);
			return true;
		}
	}

	return false;
}

function SLIDE_SWP_is_cpt_tax(&$cpt_tax_name, &$archive_page_id) {
	if (is_tax("album_category")) {
		$cpt_tax_name = "album_category";
		$archive_page_id = SLIDE_SWP_get_albums_page_id();
	} elseif (is_tax("event_category")) {
		$cpt_tax_name = "event_category";
		$archive_page_id = SLIDE_SWP_get_events_page_id();
	} elseif (is_tax("photo_album_category")) {
		$cpt_tax_name = "photo_album_category";
		$archive_page_id = SLIDE_SWP_get_gallery_page_id();
	} elseif (is_tax("video_category")) {
		$cpt_tax_name = "video_category";
		$archive_page_id = SLIDE_SWP_get_videos_page_id();
	} elseif (is_tax("artist_category")) {
		$cpt_tax_name = "artist_category";
		$archive_page_id = SLIDE_SWP_get_artists_page_id();
	} else {
		return false;
	}

	return true;
}

function SLIDE_SWP_get_pages_by_template($page_template) {
	$result = get_pages(array(
		'meta_key' => '_wp_page_template',
		'meta_value' => $page_template,
		'post_status' => 'publish'
	));
	
	$pages = array(esc_html__('Not Set', 'slide')	=> 'not_set');
	foreach($result as $page){
		$page_value = urlencode($page->guid);
		$pages[$page->post_title] = $page->ID;
	}

	return $pages;
}

function SLIDE_SWP_get_contents($filePath) {
      ob_start();
      include $filePath;
      $contents = ob_get_clean();

      return $contents;	
}

function SLIDE_SWP_fallback_menu() {
	get_template_part('views/menu/fallback');
}

function SLIDE_SWP_fallback_menu_mobile() {
	get_template_part('views/menu/fallback_mobile');
}