<?php

/*
	Declare WooCommerce Support
*/
add_theme_support('woocommerce');


/*
	Unhook the WooCommerce Wrappers
*/
remove_action('woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
remove_action('woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);

remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
remove_action('woocommerce_after_main_content', 'woocommerce_breadcrumb', 20);

/*remove sidebar*/
if (!SLIDE_SWP_woo_has_sidebar()) {
	remove_action('woocommerce_sidebar','woocommerce_get_sidebar');	
}


/*
	Hook in own functions to display the wrappers that the theme requires
*/
add_action('woocommerce_before_main_content', 'SLIDE_SWP_woocommerce_wrapper_start', 10);
add_action('woocommerce_after_main_content', 'SLIDE_SWP_woocommerce_wrapper_end', 10);


function SLIDE_SWP_woocommerce_wrapper_start() {

	if (SLIDE_SWP_woo_has_sidebar()) {
		echo '<div class="lc_content_with_sidebar lc_basic_content_padding">';
	} else {
		echo '<div class="lc_content_full lc_swp_boxed lc_basic_content_padding">';
	}
}

function SLIDE_SWP_woocommerce_wrapper_end() {
	echo '</div>';
}

/* 
	Ensure cart contents update when products are added to the cart via AJAX (place the following in functions.php) 
*/
function woocommerce_header_add_to_cart_fragment($fragments) {
	ob_start();
	?>
	<a class="cart-contents " href="<?php echo wc_get_cart_url(); ?>" title="<?php esc_html__('View your shopping cart', 'slide'); ?>">
		<i class="fas fa-shopping-bag" aria-hidden="true"></i>
		<span class="cart-contents-count">
			<?php echo esc_html(WC()->cart->get_cart_contents_count()); ?>
		</span>
	</a>
	<?php
	
	$fragments['a.cart-contents'] = ob_get_clean();
	
	return $fragments;
}