<?php get_header(); ?>


	<?php
	$center_css_class = "text_left";
	$container_class = 'lc_blog_masonry_container blog_container lc_swp_boxed';
	$gap_width = 60;
	$bricks_on_row = 3;

	/*query vars*/
	set_query_var('lc_masonry_brick_class', 'lc_blog_masonry_brick');
	?>	

	<?php if (have_posts()) { ?>

		<div class="<?php echo esc_attr($container_class); ?>" data-gapwidth="<?php echo esc_attr($gap_width); ?>" data-bricksonrow="<?php echo esc_attr($bricks_on_row); ?>">
			<?php
			while (have_posts()) : the_post();
					get_template_part('views/archive/blog_masonry');
			endwhile;
			?>
		</div>

		<div class="page_navigation lc_swp_boxed"> 
			<span class="page_nav_item swp_slide_link">
				<?php next_posts_link('Older posts'); ?>
			</span>
			<span class="page_nav_item swp_slide_link">
				<?php previous_posts_link('Newer posts'); ?>
			</span>
		</div>
	<?php } else { ?>
		<div class="lc_swp_boxed lc_basic_content_padding">
			<?php if (is_search()) { ?>
				<p><?php echo esc_html__('Sorry, no results were found matching your search criteria. Please try something else.', 'slide'); ?></p>
			<?php } else { ?>
				<p><?php echo esc_html__('Sorry, no posts matched your criteria.', 'slide'); ?></p>
			<?php } ?>
		</div>

	<?php } ?>

<?php get_footer(); ?>