<?php

function SLIDE_SWP_get_inner_bg_image() {
	return SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_custom_innner_bg_image');
}

function SLIDE_SWP_get_user_logo_img() {
	return SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_custom_logo');
}

function SLIDE_SWP_get_menu_style() {
	$menu_style = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_menu_style');

	/*cannot return empty value*/
	if (empty($menu_style)) {
		$menu_style = 'centered_menu';
	}

	return $menu_style;
}

function SLIDE_SWP_get_header_footer_width() {
	$header_width = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_header_footer_width');

	/*cannot return empty value*/
	if (empty($header_width)) {
		$header_width = 'full';
	}

	return $header_width;
}

function SLIDE_SWP_get_default_color_scheme() {
	$color_scheme = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_default_color_scheme');
	if (!empty($color_scheme)) {
		return $color_scheme;
	}

	return  'white_on_black';
}

function SLIDE_SWP_is_sticky_menu() {
	$sticky_menu = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_enable_sticky_menu');

	if (empty($sticky_menu) || ("enabled" == $sticky_menu)) {
		return true;
	}

	return false;
}

function SLIDE_SWP_is_back_to_top_enabled() {
	$back_to_top = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_back_to_top');

	if (empty($back_to_top) || ("disabled" == $back_to_top)) {
		return false;
	}

	return true;
}

function SLIDE_SWP_show_search_on_menu() {
	$hide_icon = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_hide_search_icon');

	if (empty($hide_icon)) {
		return false;
	}

	return "enabled" == $hide_icon ? false : true;
}

function SLIDE_SWP_auto_show_featured_image() {
	$auto_featured_image = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_auto_featured_image');

	if (empty($auto_featured_image)) {
		return true;
	}

	return "enabled" == $auto_featured_image ? true : false;
}

function SLIDE_SWP_single_has_sidebar() {
	$remove_singlepost_sidebar = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_remove_singlepost_sidebar');

	if (empty($remove_singlepost_sidebar)) {
		return true;
	}

	return "enabled" == $remove_singlepost_sidebar ? false : true;
}

function SLIDE_SWP_keep_blog_meta() {
	$remove_blog_post_meta = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_remove_blog_post_meta');

	if (empty($remove_blog_post_meta)) {
		return true;
	}

	return "enabled" == $remove_blog_post_meta ? false : true;
}

function SLIDE_SWP_keep_single_post_meta() {
	$remove_single_blog_post_meta = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_remove_single_blog_post_meta');

	if (empty($remove_single_blog_post_meta)) {
		return true;
	}

	return "enabled" == $remove_single_blog_post_meta ? false : true;
}

function SLIDE_SWP_woo_has_sidebar() {
	$shop_has_sidebar = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_shop_has_sidebar');

	if (empty($shop_has_sidebar)) {
		return false;
	}

	return "enabled" == $shop_has_sidebar ? true : false;
}

function SLIDE_SWP_has_cpt_comments() {
	$enable_cpt_comments = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_enable_cpt_comments');

	if (empty($enable_cpt_comments)) {
		return false;
	}

	return "enabled" == $enable_cpt_comments ? true : false;
}

function SLIDE_SWP_show_img_caption() {
	$show_img_caption = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_show_img_caption');

	if (empty($show_img_caption)) {
		return false;
	}

	return "enabled" == $show_img_caption ? true : false;
}

function SLIDE_SWP_show_ctp_tax_on_archive() {
	$show_cpt_tax = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_show_cpt_tax');

	if (empty($show_cpt_tax)) {
		return false;
	}

	return "enabled" == $show_cpt_tax ? true : false;
}

function SLIDE_SWP_show_album_date_as_year() {
	$show_album_date = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_show_album_date');

	if (empty($show_album_date)) {
		return false;
	}

	return "year" == $show_album_date ? true : false;
}

function SLIDE_SWP_get_artists_page_id() {
	$artist_page = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_artists_page');
	if (empty($artist_page)) {
		return false;
	}

	return ("not_set" == $artist_page) ? false : $artist_page;
}

function SLIDE_SWP_get_videos_page_id() {
	$videos_page = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_videos_page');
	if (empty($videos_page)) {
		return false;
	}

	return ("not_set" == $videos_page) ? false : $videos_page;
}

function SLIDE_SWP_get_gallery_page_id() {
	$gallery_page = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_gallery_page');
	if (empty($gallery_page)) {
		return false;
	}

	return ("not_set" == $gallery_page) ? false : $gallery_page;
}

function SLIDE_SWP_get_albums_page_id() {
	$albums_page = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_albums_page');
	if (empty($albums_page)) {
		return false;
	}

	return ("not_set" == $albums_page) ? false : $albums_page;
}

function SLIDE_SWP_get_events_page_id() {
	$events_page = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_events_page');
	if (empty($events_page)) {
		return false;
	}

	return ("not_set" == $events_page) ? false : $events_page;
}


function SLIDE_SWP_need_woo_sidebar_on_this_page() {
	if (!SLIDE_SWP_is_woocommerce_active()) {
		return false;
	}

	if (!SLIDE_SWP_woo_has_sidebar()) {
		return false;
	}

	if (is_shop() || 
		is_product_category() || 
		is_product_tag() || 
		is_product()) {
		return SLIDE_SWP_woo_has_sidebar();
	}

	return false;
}

function SLIDE_SWP_get_available_social_profiles() {
	$user_profiles = array();

	$available_profiles = array(
		/*'icon name fa-[icon name]'	=> 'settings name'*/
		'facebook-f'			=> 'lc_fb_url',
		'twitter'			=>'lc_twitter_url',		
		'instagram'			=> 'lc_instagram_url',		
		'snapchat-ghost'	=> 'lc_snapchat_url',		
		'pinterest'			=>'lc_pinterest_url',		
		'google-plus'		=>'lc_gplus_url',	
		'youtube'			=>'lc_youtube_url',	
		'vimeo'				=> 'lc_vimeo_url',		
		'soundcloud'		=>'lc_soundcloud_url',	
		'play'				=> 'lc_gplay_url',		
		'amazon'			=>'lc_amazon_music_url',
		'apple'				=>'lc_itunes_url',
		'spotify'			=> 'lc_spotify_url',
		'linkedin'			=> 'lc_linkedin_url',
		'imdb'				=> 'lc_imdb_url',
		'vk'				=> 'lc_vk_url'
	);

	foreach ($available_profiles as $key =>	$profile) {
		$profile_url = SLIDE_SWP_get_theme_option('slide_theme_social_options', $profile);

		if (!empty($profile_url)) {
			$single_profile = array();
			$single_profile['url'] 	= $profile_url;
			$single_profile['icon'] 	= $key;

			$user_profiles[] = $single_profile;
		}
	}

	return $user_profiles;
}

/*getters for footer options*/
function SLIDE_SWP_get_footer_color_scheme() {
	$footer_color_scheme = SLIDE_SWP_get_theme_option('slide_theme_footer_options', 'lc_footer_widgets_color_scheme');
	
	if (!empty($footer_color_scheme)) {
		return $footer_color_scheme;
	}

	return 'white_on_black';
}

function SLIDE_SWP_get_footer_bg_image() {
	return SLIDE_SWP_get_theme_option('slide_theme_footer_options', 'lc_footer_widgets_background_image');
}

function SLIDE_SWP_get_footer_bg_color() {
	$footer_background_color = SLIDE_SWP_get_theme_option('slide_theme_footer_options', 'lc_footer_widgets_background_color');
	
	if (!empty($footer_background_color)) {
		return $footer_background_color;
	}

	return 'rgba(19, 19, 19, 1)';
}

function SLIDE_SWP_get_copyrigth_text() {
	return esc_html(SLIDE_SWP_get_theme_option('slide_theme_footer_options', 'lc_copyright_text'));
}

function SLIDE_SWP_get_copyright_bgc() {
	$copy_bgc = SLIDE_SWP_get_theme_option('slide_theme_footer_options', 'lc_copyright_text_bg_color');
	if (!empty($copy_bgc)) {
		return $copy_bgc;
	}

	return 'rgba(29, 29, 29, 1)';
}

function SLIDE_SWP_what_copyright_shows() {
	$copyright_shows = SLIDE_SWP_get_theme_option('slide_theme_footer_options', 'lc_copyright_shows');
	if (empty($copyright_shows)) {
		return 'copy_text_only';
	}

	return $copyright_shows;
}

function SLIDE_SWP_get_copyrigth_color_scheme() {
	$copy_color_scheme = SLIDE_SWP_get_theme_option('slide_theme_footer_options', 'lc_copyright_text_color');
	if (!empty($copy_color_scheme)) {
		return $copy_color_scheme;
	}

	return 'white_on_black';
}

function SLIDE_SWP_get_copy_logo() {
	return SLIDE_SWP_get_theme_option('slide_theme_footer_options', 'lc_copyright_logo');
}

function SLIDE_SWP_get_copy_bg_img() {
	return SLIDE_SWP_get_theme_option('slide_theme_footer_options', 'lc_copyright_bg_img');
}

function SLIDE_SWP_get_side_menu_bg() {
	$side_menu_bgc = SLIDE_SWP_get_theme_option('slide_theme_footer_options', 'lc_side_menu_bg_color');

	if ('' == $side_menu_bgc) {
		return 'rgba(23, 25, 41, 1)';
	}

	return $side_menu_bgc;
}

function SLIDE_SWP_get_side_menu_cs() {
	$side_menu_color_scheme = SLIDE_SWP_get_theme_option('slide_theme_footer_options', 'lc_side_menu_cs');
	if (empty($side_menu_color_scheme)) {
		return 'white_on_black';
	}

	return $side_menu_color_scheme;
}

function SLIDE_SWP_get_post_bg_image($post_id) {
	return get_post_meta($post_id, 'js_swp_meta_bg_image', true);
}

function SLIDE_SWP_get_post_overlay_color($post_id) {
	return get_post_meta($post_id, 'lc_swp_meta_page_overlay_color', true);
}

function SLIDE_SWP_get_contact_address() 
{
	return esc_html(SLIDE_SWP_get_theme_option('slide_theme_contact_options', 'lc_contact_address'));
}

function SLIDE_SWP_get_contact_email() 
{
	return sanitize_email(SLIDE_SWP_get_theme_option('slide_theme_contact_options', 'lc_contact_email'));
}

function SLIDE_SWP_get_contact_phone() 
{
	return esc_html(SLIDE_SWP_get_theme_option('slide_theme_contact_options', 'lc_contact_phone'));
}

function SLIDE_SWP_get_2nd_contact_phone() 
{
	return esc_html(SLIDE_SWP_get_theme_option('slide_theme_contact_options', 'lc_contact_phone2'));
}

function SLIDE_SWP_get_contact_fax() 
{
	return esc_html(SLIDE_SWP_get_theme_option('slide_theme_contact_options', 'lc_contact_fax'));
}

function SLIDE_SWP_use_default_fonts() {
	$fonts_custom_default = SLIDE_SWP_get_theme_option('slide_theme_fonts_options', 'lc_fonts_custom_default');
	if (empty($fonts_custom_default)) {
		return true;
	}

	if ("use_defaults" == $fonts_custom_default) {
		return true;
	}

	return false;
}

function SLIDE_SWP_get_user_primary_font() {
	$primary_font = SLIDE_SWP_get_theme_option('slide_theme_fonts_options', 'lc_primary_font');
	if (empty($primary_font)) {
		return 'Roboto';
	}

	return $primary_font;
}

function SLIDE_SWP_get_user_secondary_font() {
	$secondary_font = SLIDE_SWP_get_theme_option('slide_theme_fonts_options', 'lc_secondary_font');
	if (empty($secondary_font)) {
		return 'Roboto';
	}

	return $secondary_font;
}

function SLIDE_SWP_generate_fonts_family($primary, $secondary) {
	$str = SLIDE_SWP_get_contents(get_template_directory() . '/assets/google_fonts/fonts.json'); 
	$fonts_json = json_decode($str, true);

	$final_fonts = '';
	$found_fonts = 0;
	foreach($fonts_json as $font_json) {
		if (($primary == $font_json['family']) || 
			($secondary == $font_json['family'])) {

			$found_fonts++;
			if (strlen($final_fonts)) {
				$final_fonts .= '|';
			}
			$final_fonts .= str_replace(' ', '+', $font_json['family']) . ':' . $font_json['variants'];

			/*get out of the loop after two fonts found*/
			if (2 == $found_fonts) {
				break;
			}
		}/*if*/
	}/*foreach*/

	return $final_fonts . '&subset=latin,latin-ext';
}

if ( !function_exists('SLIDE_SWP_get_fonts_family_from_settings') ) {
	function SLIDE_SWP_get_fonts_family_from_settings() {
		if (SLIDE_SWP_use_default_fonts()) {
			return 'Roboto:300,400,500,700,900&amp;subset=latin-ext';
		}

		$primary_font = SLIDE_SWP_get_user_primary_font();
		$secondary_font = SLIDE_SWP_get_user_secondary_font();

		return SLIDE_SWP_generate_fonts_family($primary_font, $secondary_font);
	}
}