<?php
/*
	Template Name: Blog
*/
?>

<?php get_header(); ?>

<?php
	/*create the query*/
	if (get_query_var('paged')) {
		$paged = get_query_var('paged'); 
	} elseif (get_query_var('page')) { 
		$paged = get_query_var('page'); 
	} else {
		$paged = 1; 
	}

	$posts_per_page = get_option('posts_per_page');
	$offset = ($paged - 1) * $posts_per_page;

	$args = array(
		'numberposts'	=> -1,
		'posts_per_page'   => $posts_per_page,
		'paged'			   => $paged,
		'offset'           => $offset,
		'orderby'          => 'post_date',
		'order'            => 'DESC',
		'post_type'        => 'post',
		'post_status'      => 'publish',
		'suppress_filters' => false
	);
	$keep_old_wp_query = $wp_query;

	$wp_query= null;
	$wp_query = new WP_Query();
	$wp_query->query($args);
	?>

	<?php
	$center_css_class = "text_left";
	$container_class = 'lc_blog_masonry_container blog_container lc_swp_boxed';
	$gap_width = 60;
	$bricks_on_row = 3;

	/*query vars*/
	set_query_var('lc_masonry_brick_class', 'lc_blog_masonry_brick');

	if ($wp_query->have_posts()) { ?>

		<div class="<?php echo esc_attr($container_class); ?>" data-gapwidth="<?php echo esc_attr($gap_width); ?>" data-bricksonrow="<?php echo esc_attr($bricks_on_row); ?>">
			<?php
			while ($wp_query->have_posts()) : $wp_query->the_post();
					get_template_part('views/archive/blog_masonry');
			endwhile;
			?>
		</div>

		<div class="page_navigation lc_swp_boxed"> 
			<span class="page_nav_item swp_slide_link">
				<?php next_posts_link('Older posts'); ?>
			</span>
			<span class="page_nav_item swp_slide_link">
				<?php previous_posts_link('Newer posts'); ?>
			</span>
		</div>
	<?php } else { ?>
		<div class="lc_swp_boxed lc_basic_content_padding">
			<p><?php esc_html__('Sorry, no posts matched your criteria.', 'slide'); ?></p>
		</div>

	<?php 
	}
	$wp_query = null; $wp_query = $keep_old_wp_query;
?>

<?php get_footer(); ?>