<?php
/*
	var: 	
		$items_on_row
		$item_count
*/
	$has_right_padding = (0 == $item_count % $items_on_row) ? '' : ' has_right_padding';
	$bg_img_url = "";
	if (has_post_thumbnail()) {
		$bg_img_url = get_the_post_thumbnail_url('', 'full');
	}
	$custom_css_class = ' albums_' . $items_on_row . "_on_row";
	$vinyl_src = get_template_directory_uri() . "/core/img/slide_record.png";

?>

<div class="single_album_item<?php echo esc_attr($has_right_padding).esc_attr($custom_css_class); ?>">
	<a href="<?php the_permalink();?>">
		<div class="image_vinyl_container">
			<div class="album_image_container lc_swp_background_image" data-bgimage="<?php echo esc_url($bg_img_url); ?>">
			</div>
			<div class="slide_vinyl transition4">
				<img alt="<?php the_title(); ?>" src="<?php echo esc_url($vinyl_src); ?>">
				<img src="<?php echo esc_url($bg_img_url); ?>" class="image_on_vinyl">
			</div>
		</div>
		
		<div class="album_details">
			<h3 class="album_title album_heading transition4"> <?php the_title(); ?> </h3>
			<div class="album_cat_list">
				<?php
				if (has_term('', "album_category")) {
					the_terms("", "album_category", '', ' ', '');	
				}
				?>
			</div>			
		</div>
	</a>
</div>