<?php
/*
	var: 	
		$items_on_row
		$item_count
*/
	$has_right_padding = (0 == $item_count % $items_on_row) ? '' : ' has_right_padding';
	$bg_img_url = "";
	if (has_post_thumbnail()) {
		$bg_img_url = get_the_post_thumbnail_url('', 'full');
	}

	$custom_css_class = ' artists_' . $items_on_row . "_on_row";

	$artist_nickname = esc_html(get_post_meta(get_the_ID(), 'artist_nickname', true));
	/*social options*/
	$available_profiles = array(
		/*'icon name fa-[icon name]'	=> 'settings name'*/
		'facebook-f'			=> 'artist_facebook',
		'twitter'			=>'artist_twitter',		
		'instagram'			=> 'artist_instagram',
		'soundcloud'		=>'artist_soundcloud',	
		'youtube'			=>'artist_youtube'
	);
	$artist_profiles = array();
	foreach ($available_profiles as $key =>	$profile) {
		$profile_url = esc_url(get_post_meta(get_the_ID(), $profile, true));

		if (!empty($profile_url)) {
			$single_profile = array();
			$single_profile['url'] 	= $profile_url;
			$single_profile['icon'] 	= $key;

			$artist_profiles[] = $single_profile;
		}
	}


?>

<div class="single_artist_item <?php echo esc_attr($has_right_padding).esc_attr($custom_css_class); ?>">
		<div class="artist_img_container lc_swp_background_image" data-bgimage="<?php echo esc_url($bg_img_url); ?>">
			<div class="album_overlay artist_overlay lc_swp_overlay transition3 lc_js_link" data-href="<?php the_permalink(); ?>" data-target="_self"></div>
			<div class="artist_item_socials">
				<?php foreach ($artist_profiles as $social_profile) { ?>
					<div class="artist_social_profile">
						<a href="<?php echo esc_url($social_profile['url']); ?>" target="_blank" class="artist_social_link">
							<i class="fab fa-<?php echo esc_attr($social_profile['icon']); ?>"></i>
						</a>
					</div>
				<?php } ?>		
			</div>
		</div>
		
		<a href="<?php the_permalink();?>">
			<h3 class="artist_title album_heading transition4"> <?php the_title(); ?> </h3>
		</a>
		<div class="artist_nickname"> <?php echo esc_html($artist_nickname); ?> </div>
</div>