<?php
	
	$post_id 		= SLIDE_SWP_get_current_page_id();

	$title			= get_the_title();
	$subtitle 		= esc_html(get_post_meta($post_id, 'lc_swp_meta_subtitle', true));
	$color_theme 	= get_post_meta($post_id, 'lc_swp_meta_heading_color_theme', true);
	$heading_style 	= get_post_meta($post_id, 'lc_swp_meta_heading_full_color', true); /*title_centered, title_left*/
	$bg_image 		= get_post_meta($post_id, 'lc_swp_meta_heading_bg_image', true);
	$overlay 		= get_post_meta($post_id, 'lc_swp_meta_heading_overlay_color', true);

	$DEFA_HEADING_STYLE = "title_centered";

	/* reset values to default for default templates*/
	if (is_author() || 
		is_category() || 
		(is_archive() && !SLIDE_SWP_is_product_archive()) || 
		is_home() || 
		is_search()) {
		$subtitle = $bg_image = $overlay = "";
		$color_theme = SLIDE_SWP_get_default_color_scheme();
		$heading_style = $DEFA_HEADING_STYLE;
	}

	if (!strlen($heading_style)) {
		$heading_style = $DEFA_HEADING_STYLE;
	}

	/*404 template*/
	if (is_404()) {
		$subtitle = $title = "";

		/*since the background header image is always the same, the color scheme should be white on black*/
		$color_theme = " white_on_black";
		$heading_style = $DEFA_HEADING_STYLE . " pnf_template";
		$bg_image = $overlay = "";
	}

	if (SLIDE_SWP_is_woocommerce_special_page()) {
		$color_theme = SLIDE_SWP_get_default_color_scheme();
	}

	/*for product category, use the category image as header image*/
	if (function_exists("is_product_category")) {
		if (is_product_category()) {
			global $wp_query;
			$cat = $wp_query->get_queried_object();
	 		$thumbnail_id = get_woocommerce_term_meta($cat->term_id, 'thumbnail_id', true);
	 		$image = wp_get_attachment_url($thumbnail_id);
	 		if ($image) {
				$bg_image = $image;
	 		}
 		}
	}

	/*title for special templates - keep this the latest processed data*/
	if (is_author()) {
		$title = esc_html__('Author: ', 'slide').get_the_author();
	} elseif (is_category()) {
		$title = single_cat_title("", FALSE);
	} elseif (is_archive()) {
		if (is_tax()) {
			/*custom taxonomy*/
			$term = get_term_by('slug', get_query_var('term'), get_query_var('taxonomy'));
			$title = $term->name;
		} else {
			$title = get_the_time(get_option('date_format'));	
		}
	} elseif (is_home()) {
		$title = esc_html__("Blog", 'slide');
	} elseif (is_search()) {
		$title = get_search_query();
	}

	SLIDE_SWP_set_title_and_centering_for_cpt_tax($title, $subtitle, $heading_style);

	/*treat separately the shop and product page [[[*/
	if (function_exists("is_shop")) {
		if (is_shop()) {
			$title = woocommerce_page_title(false);
		}
	}
	if (function_exists("is_product")) {
		if (is_product()) {
			$title = woocommerce_page_title(false);
		}
	}
	/*treat separately the shop and product page ]]]*/

	$supported_post_types = array('js_videos', 'js_events', 'js_albums', 'js_photo_albums');
	$has_cpt_tax = '';
	if (is_singular($supported_post_types)) {
		$has_cpt_tax = " has_cpt_tax";
	}

?>

<div id="heading_area" class="<?php echo esc_attr($color_theme); ?>">
	<?php if (!empty($overlay)) { ?>
		<div class="lc_swp_overlay" data-color="<?php echo esc_attr($overlay); ?>"></div>
	<?php } ?>

	<?php if (!empty($bg_image)) { ?>
		<div class="lc_swp_background_image lc_heading_image_bg" data-bgimage="<?php echo esc_url($bg_image); ?>"></div>
	<?php } ?>

	<div class="heading_content_container lc_swp_boxed <?php echo esc_attr($has_cpt_tax) . " " . esc_attr($heading_style); ?>">
		<div class="heading_titles_container">
			<?php if (!empty($subtitle)) { ?>
				<div class="heading_area_subtitle <?php echo esc_attr($heading_style); ?>">
					<h2 class="<?php echo esc_attr($heading_style); ?>"><?php echo esc_html($subtitle); ?></h2>
				</div>
			<?php } ?>

			<div class="heading_area_title <?php echo esc_attr($heading_style); ?>">
				<h1 class="<?php echo esc_attr($heading_style); ?>"> <?php echo esc_html($title); ?> </h1>
			</div>

		</div>

		<?php
			/*show post meta*/
			if (is_single($post_id)) {
				get_template_part('views/utils/post_meta'); 
			}

			/*show custom categories for custom post types*/
			get_template_part('views/utils/cpt_post_meta');

			/*show current custom categories for cpt archive pages like videos, discography, etc*/
			if (SLIDE_SWP_show_ctp_tax_on_archive()) { 
				get_template_part('views/utils/cpt_archive_meta');
				get_template_part('views/utils/cpt_tax_meta');
			}
		?>
	</div>
</div>