<?php 
/*
* The Loop for portfolio overview pages. Works in conjunction with the file template-portfolio.php and taxonomy-portfolio_entries.php
*/



global $avia_config;
if(isset($avia_config['new_query'])) { query_posts($avia_config['new_query']); }

$loop_counter = 1;
// check if we got a page to display:
if (have_posts()) :
	
	$extraClass = 'first';
	$style = 'portfolio-entry-no-description';
	
	$grid = 'grid3';
	$image_size = 'portfolio4';
	$showcaption = true;
	$hr_class = "hr";
	$render_hr = false;
	
	
	switch($avia_config['portfolio_columns'])
	{
		case "2": $grid = 'grid6';  $image_size = 'portfolio2'; break;
		case "3": $grid = 'grid4';  $image_size = 'portfolio3'; break;
		case "4": $grid = 'grid3';  $image_size = 'portfolio4'; break;
		case "2 sidebar_left single_sidebar":  $grid = 'grid4';  $image_size = 'portfolio3'; break;
		case "2 sidebar_right single_sidebar": $grid = 'grid4';  $image_size = 'portfolio3'; break;		
		case "3 sidebar_left":  $grid = 'grid_third1';  $image_size = 'portfolio3_sb'; break;
		case "3 sidebar_right": $grid = 'grid_third1';  $image_size = 'portfolio3_sb'; break;
		case "1 dual-sidebar":  $grid = '';  $image_size = 'page'; break;
		case "2 dual-sidebar":  $grid = 'grid3';  $image_size = 'portfolio4'; break;
		case "1":  $grid = 'fullwidth';  $image_size = 'aviacordion'; if(isset($avia_config['remove_portfolio_text']) && $avia_config['layout'] =='fullwidth') { $image_size = 'featured';} break;
	}
	
	$avia_config['portfolio_columns_iteration'] = $avia_config['portfolio_columns'][0];
	if(!isset($avia_config['remove_portfolio_text'])) $style = 'portfolio-entry-description';
	
	
	$includeArray = "";
	if(isset($avia_config['new_query']['tax_query'][0]['terms'])) $includeArray = $avia_config['new_query']['tax_query'][0]['terms'];
	
	$args = array(
	
		'taxonomy'	=> 'portfolio_entries',
		'hide_empty'=> 0,
		'include'	=> $includeArray
	
	);

	$categories = get_categories($args);
	$container_id = "";
	
	
	if(!isset($avia_config['portfolio_sorting']) || $avia_config['portfolio_sorting'] == 'yes')
	{
		if(!empty($categories[0]))
		{
			$output = "<div id='js_sort_items' >";
	
			$hide = "hidden";
			if (isset($categories[1])){ $hide = ""; }
			
			$output .= "<div class='sort_by_cat $hide '>";
			$output .= "<a href='#' id='all_sort' class='active_sort'>".__('All','avia_framework')."</a>";
			
			foreach($categories as $category)
			{
				$output .= "<span class='text-sep'>/</span><a href='#' id='".$category->category_nicename."_sort'>".$category->cat_name."</a>";
				$container_id .= $category->term_id;
			}
			
			$output .= "</div>";
			
	
			$output .= "</div>";
			
			echo $output;
		}
	}
	

		
	//iterate over the posts
	while (have_posts()) : the_post();	
	
	//get the categories for each post and create a string that serves as classes so the javascript can sort by those classes
	$sort_classes = "";
	$item_categories = get_the_terms( $id, 'portfolio_entries' );

	if(is_object($item_categories) || is_array($item_categories))
	{
		foreach ($item_categories as $cat)
		{
			$sort_classes .= $cat->slug.'_sort ';
		}
	}
		
		
	if($render_hr) echo "<div class='hr_portfolio $hr_class'></div>";

?>

		
		<div class='post-entry all_sort <?php echo $sort_classes.' '.$grid.' '.$extraClass.' '.$style; ?>'>
														
			<?php 
			$slider = new avia_slideshow(get_the_ID());
 	 		echo $slider->display_small($image_size, $showcaption);
 	 		
 	 		//$showcaption
			
			if(!isset($avia_config['remove_portfolio_text']))
			{
				echo '<div class="post-content">';
				echo "<h1 class='post-title'>";
				echo "<a href='".get_permalink()."' rel='bookmark' title='".__('Permanent Link:','avia_framework')." ".get_the_title()."'>".get_the_title()."</a>";
				echo "</h1>";
				
				echo '<div class="entry-content">';
					 
				if($avia_config['portfolio_columns_iteration'] == 1)
				{
					echo '<span class="portfolio-categories minor-meta">';
					echo get_the_term_list(  get_the_ID(), 'portfolio_entries', '<strong>'.__('Categories','avia_framework').': </strong><span>', '</span><span class="text-sep">/</span><span>','</span>');
					echo '</span>';

				}
				
				the_excerpt(); 
				echo '<a class="more-link" href="'. get_permalink().'">'.__('Read more  &rarr;','avia_framework').'</a>';
				echo "</div>";
				echo "</div>";
				
			}
			else
			{
				$hr_class = 'hr hr_invisible';
			}
			 
		?>				        
		<!-- end post-entry-->
		</div>
	
	<?php 

	$loop_counter++;
	$extraClass = "";
	$render_hr = false;
	if($loop_counter > $avia_config['portfolio_columns_iteration'])
	{
		$loop_counter = 1;
		$extraClass = 'first';
		$render_hr = true;
	}


	endwhile;
	
	
	
	if(!isset($avia_config['remove_pagination'] ))
	{
		echo "<div class='hr hr_invisible'></div>";
		echo avia_pagination();	
	}	
	echo "<!-- end -->"; //dont remove
	else: 
?>	
	
	<div class="entry">
		<h1 class='post-title'><?php _e('Nothing Found', 'avia_framework'); ?></h1>
		<p><?php _e('Sorry, no posts matched your criteria', 'avia_framework'); ?></p>
	</div>
<?php

	


	endif;
	
		
?>