<?php
##################################################################
# AVIA FRAMEWORK by Kriesi

# this include calls a file that automatically includes all 
# the files within the folder framework and therefore makes 
# all functions and classes available for later use
							
require_once( 'framework/avia_framework.php' );

##################################################################


//register additional image thumbnail sizes that should be generated when user uploads an image:
global $avia_config;

$avia_config['imgSize']['widget'] 		= array('width'=>36,  'height'=>36 );		// small preview pics eg sidebar news
$avia_config['imgSize']['related'] 		= array('width'=>130, 'height'=>130);		// small images for related items (also for small blog overview images)
$avia_config['imgSize']['portfolio4'] 	= array('width'=>210, 'height'=>160);		// small preview pic for default portfolio (4 columns )
$avia_config['imgSize']['portfolio3'] 	= array('width'=>290, 'height'=>200);		// medium preview pic for 3 column portfolio
$avia_config['imgSize']['portfolio3_sb']= array('width'=>183, 'height'=>160);		// medium preview pic for 3 column portfolio with sidebar
$avia_config['imgSize']['portfolio2'] 	= array('width'=>450, 'height'=>300);		// medium preview pic for 2 column portfolio and small 3d slider
$avia_config['imgSize']['page'] 		= array('width'=>610, 'height'=>255);		// image for pages and one column portfolio
$avia_config['imgSize']['blog'] 		= array('width'=>450, 'height'=>255);		// image for blog posts (big)
$avia_config['imgSize']['featured'] 	= array('width'=>930, 'height'=>370);		// big images for fullsize pages and fullsize 2D & 3D slider
$avia_config['imgSize']['fullsize'] 	= array('width'=>930, 'height'=>523);		// big images for single portfolio pages
$avia_config['imgSize']['aviacordion'] 	= array('width'=>610, 'height'=>370);		// big Image for aviacordion


/*preview images for special column sizes of the dynamic template. you can remove those if you dont use them, it will save performance while uploading images and will also save ftp storage*/
$avia_config['imgSize']['grid6'] 		= array('width'=>450, 'height'=>160); 		// half sized images when using 4 columns
$avia_config['imgSize']['grid8'] 		= array('width'=>610, 'height'=>200);		// two/third image	
$avia_config['imgSize']['grid9'] 		= array('width'=>690, 'height'=>160);		// three/fourth image

///////



avia_backend_add_thumbnail_size($avia_config);






##################################################################
# Frontend Stuff necessary for the theme:
##################################################################


$lang = TEMPLATEPATH . '/lang';
load_theme_textdomain('avia_framework', $lang);


/* Register frontend javascripts: */

wp_register_script( 'avia-default', AVIA_BASE_URL.'js/avia.js', array('jquery','avia-html5-video'), 1, false );
wp_register_script( 'avia-prettyPhoto',  AVIA_BASE_URL.'js/prettyPhoto/js/jquery.prettyPhoto.js', 'jquery', "3.0.1", true);
wp_register_script( 'avia-html5-video',  AVIA_BASE_URL.'js/projekktor/projekktor.min.js', 'jquery', "1", true);
wp_register_script( 'avia-slider',  AVIA_BASE_URL.'js/aviaslider.js', 'jquery', "2.5.2", true);
wp_register_script( 'aviacordion',  AVIA_BASE_URL.'js/aviacordion-dev.js', 'jquery', "1.0.0", true);
wp_register_script( 'avia_fade_slider',  AVIA_BASE_URL.'js/avia_fade_slider-dev.js', 'jquery', "1.0.0", true);



/* Activate native wordpress navigation menu and register a menu location */
add_theme_support('nav_menus');
$avia_config['nav_menus'] = array('avia' => 'Main Menu', 'avia2'=> 'Sub Menu');
foreach($avia_config['nav_menus'] as $key => $value){ register_nav_menu($key, THEMENAME.' '.$value); }




//load some frontend functions in folder include:

require_once( 'includes/admin/register-widget-area.php' );		// register sidebar widgets for the sidebar and footer
require_once( 'includes/admin/register-portfolio.php' );		// register custom post types for portfolio entries
require_once( 'includes/admin/register-styles.php' );			// register the styles for dynamic frontend styling
require_once( 'includes/admin/register-shortcodes.php' );		// register wordpress shortcodes
require_once( 'includes/loop-comments.php' );					// necessary to display the comments properly
require_once( 'includes/helper-slideshow.php' ); 				// holds the class that generates the 2d & 3d slideshows, as well as feature images
require_once( 'includes/helper-templates.php' ); 				// holds some helper functions necessary for dynamic templates
require_once( 'includes/admin/compat.php' );					// compatibility functions for 3rd party plugins
require_once( 'includes/admin/register-menu-walker.php' );		// custom menu walker that allows for description bellow the menu item

//activate framework widgets
register_widget( 'avia_tweetbox');
register_widget( 'avia_newsbox' );
register_widget( 'avia_portfoliobox' );
register_widget( 'avia_socialcount' );
register_widget( 'avia_combo_widget' );
register_widget( 'avia_partner_widget' );

//call functions for the theme
add_filter('the_content_more_link', 'avia_remove_more_jump_link');
add_post_type_support('page', 'excerpt');


//allow mp4, webm and ogv file uploads
add_filter('upload_mimes','avia_upload_mimes');
function avia_upload_mimes($mimes){ return array_merge($mimes, array ('mp4' => 'video/mp4', 'ogv' => 'video/ogg', 'webm' => 'video/webm')); }


//change default thumbnail size on theme activation
add_action('avia_backend_theme_activation', 'avia_set_thumb_size');
function avia_set_thumb_size() {update_option( 'thumbnail_size_h', 80 ); update_option( 'thumbnail_size_w', 80 );}


//set menu description to be visible on theme acivation
add_action('avia_backend_theme_activation', 'avia_show_menu_description');
function avia_show_menu_description()
{
	global $current_user;
    get_currentuserinfo();
	$old_meta_data = $meta_data = get_user_meta($current_user->ID, 'managenav-menuscolumnshidden', true);
	
	if(is_array($meta_data) && isset($meta_data[0]))
	{
		$key = array_search('description', $meta_data);
		
		if($key !== false)
		{	
			unset($meta_data[$key]);
			update_user_meta( $current_user->ID, 'managenav-menuscolumnshidden', $meta_data, $old_meta_data );
		}
	}	
	else
	{
			update_user_meta( $current_user->ID, 'managenav-menuscolumnshidden', array('link-target', 'css-classes', 'xfn') );
	}
}



